<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<html>
<head>
  <title>Initial TMC Authentication Setup</title>
  <link rel="shortcut icon" href="${pageContext.request.contextPath}/images/favicon.ico" />
  <link type="text/css" href="${pageContext.request.contextPath}/styles/kendo.common.min.css" rel="stylesheet" />
  <link type="text/css" href="${pageContext.request.contextPath}/styles/kendo.default.min.css" rel="stylesheet" />
  <link type="text/css" href="${pageContext.request.contextPath}/css/monitor.css" rel="stylesheet" />
  <script type="text/javascript" src="${pageContext.request.contextPath}/js/jquery.min.js"></script>
  <script type="text/javascript" src="${pageContext.request.contextPath}/javascript/banner.js"></script> 
  <script type="text/javascript"> 
	  $(document).ready(function() {
	   	var mm = new MarketingManager();
	   });
	  
	    function handleError(msg, jqXHR, textStatus, errorThrown) {
	        switch (jqXHR.status) {
	          case 12029:
	            msg += "; a connection to the server could not be created";
	            break;
	          case 400:
	            msg += "; " + textStatus;
	            break;
	          case 409:
	            msg += "; the name you specified is already in use, please choose another one";
	            alert(msg);
	            break;
	          default:
	            msg += "; " + errorThrown;
	        }
	        window.status = msg;
	        // alert(msg);
	      }
	  
	  function useAuthentication(authenticationEnabled) {
		  var jqxhr = $.ajax({
	          type: "PUT",
	          url: "api/config/authentication/" ,
	          success: function(data) {
					//reload the page
	            	window.location.href=window.location.href;
	          },
	          processData: false,
	          data: JSON.stringify(authenticationEnabled),
	          contentType: "application/json"
	        }).error(function(jqXHR, textStatus, errorThrown) {
	          var msg = "Failed to update authentication enablement";
	          handleError(msg, jqXHR, textStatus, errorThrown);
	        });
	        return jqxhr;
	  }
	  
  </script>  
  <style>
    .header {
      height: 100px;
    }
    .formElement {
      margin: 5px;
      padding: 5px;
      border-style: solid;
      border-width: 1px;
    }

    #adminDiv {
      margin-bottom: 20px;
    }
    #operatorDiv {
      margin-bottom: 20px;
    }
    #formDiv {
      border-style: solid;
      border-width: 1px;
      margin-left:30%;
      width: 500px;
      padding:20px;
    }
    .error {
      color: red;
      font-weight: bold;
    }
    label {
      display:block;
      float:left;
      width:225px;
    }
    p {
      font-weight: bold;
      text-align: center;
      margin-bottom: 15px;
    }
    input[type=submit] {
      display:block;
      margin-left: 2px;
    }
  </style>
</head>
<body>
<div id="header">
  <div id="headerContent">
    <div id="tmcLogo"></div>
    <div id="adContent"></div>
  </div>
</div>
<br/>

<div id="formDiv" class="k-content k-state-active">
  <div>
    <p>Welcome to the TMC authentication setup page.</p> <p>You can use the TMC without authentication enabled (you will have the opportunity to enable authentication later in the Settings panel)</p>
  </div>
  <div align="right">
    <a href="${pageContext.request.contextPath}/tmc-help.html#account-setup" target="_blank">Help</a>
  </div>
  <div id="adminDiv" class="formElement">
    <button type='button' onClick="useAuthentication(false)" id="skipAuthentication" class="k-button" >Disable authentication</button>
    <button type='button' onClick="useAuthentication(true)" id="useAuthentication" class="k-button" style="float:right;">Setup and enforce authentication</button>
  </div>
</div>

</body>
</html>