<%@ page import="com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener" %>
<%@ page import="com.terracotta.management.user.UserRole" %>
<%@ page import="com.terracotta.management.security.Authorizer" %>
<%@page import="org.terracotta.management.ServiceLocator"%>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<div class="navigator-agent" style="display:none;height:100%;overflow:hidden;">
  <div id="tabstrip" style="height:100%;">
    <ul>
      <li id="overview" class="k-state-active">Overview</li>
      <li id="monitoring">Monitoring</li>
      <% if (TMSEnvironmentLoaderListener.HAS_LICENSE == false ||
          ServiceLocator.locate(Authorizer.class).isUserInRole(UserRole.ADMIN)) { %>
      <li id="management">Management</li>
      <% } %>
      <li id="diagnostics">Diagnostics</li>
    </ul>
    <div id="overviewContent" style="height:100%;">
      <div style="display:table;width:100%;">
        <div class="overviewToggle"> 
          <a href="#" class="toggleOn" id="healthMetrics2"><div class="leftToggle gradient" id="healthMetricsButton">Health Metrics</div></a>
          <a href="#" class="toggleOff" id="topology2"><div class="rightToggle gradient" id="topologyButton">Topology</div></a>
        </div>
      </div>
      <div id="healthMetrics">
        <div id="grid" style="height:100%;"></div>
      </div>
      <div id="topology" style="display:none;">
        <div id="topologyContent" style="height:100%;overflow:auto;"></div>    
      </div>
    </div>
    <div id="monitoringContent" style="height:100%">
      <div id="top" class="selector-controls">
        <ul>
          <li>CacheManager:</li>
          <li>
            <input id="cacheManagerSelector"/>
          </li>
          <li>Cache:</li>
          <li>
            <input id="cacheSelector"/>
          </li>
        </ul>
      </div>
      <div style="display:table;width:100%;">
        <div class="overviewToggle"> 
  		    <a href="#" class="toggleOn" id="charts2"><div class="leftToggle gradient" id="chartsButton">Charts</div></a>
  		    <a href="#" class="toggleOff" id="statistics2"><div class="rightToggle gradient" id="statisticsButton">Statistics</div></a>
       	</div>
      </div>
      <div id="charts">
        <table cellspacing="0px" cellpadding="0px" border="0" title="Click a chart to change what it's graphing">
          <tr>
            <td>
              <div id="CacheHitRate" class="chart k-content" style="margin:0px;padding:0px;"></div>
            </td>
            <td>
              <div id="CacheMissRate" class="chart k-content" style="margin:0px;padding:0px;"></div>
            </td>
          </tr>
          <tr>
            <td>
              <div id="CachePutRate" class="chart k-content" style="margin:0px;padding:0px;"></div>
            </td>
            <td>
              <div id="CacheAverageGetTime" class="chart k-content" style="margin:0px;padding:0px;"></div>
            </td>
          </tr>
        </table>
      </div>
      <div id="statistics" style="display:none;">
        <div id="top">
          <div id="menu_sm" class="gradient">
  			    <a id="configureColumns" href="#" rel="tooltip" class="menuManage" style="float:right;" title="Choose statistics to display">
              <div class="menuItem" id="manageConnections" style="margin-top:0px;">Configure columns</div>
            </a>
		      </div>
        </div>
        <div id="grid"></div>
      </div>
    </div>
    <% if (TMSEnvironmentLoaderListener.HAS_LICENSE == false ||
        ServiceLocator.locate(Authorizer.class).isUserInRole(UserRole.ADMIN)) { %>
    <div id="managementContent" style="height:100%;">
      <div id="top" style="padding:0.5em;">
			  Click a grid cell to see possible actions.
			  <span id="menu_sm" class="gradient" style="padding-top:5px;display:inline;">        
          <a href="tmc-help.html#ehcache-connection-manage" target="_blank" class="menuHelp">
            <span class="menuItem_sm">Help</span>
          </a>  
        </span>
      </div>
      <div id="grid"></div>
    </div>
    <% } %>
    <div id="diagnosticsContent" style="height:100%;">
      <div id="top" class="selector-controls">
        <ul>
          <li>CacheManager:</li>
          <li>
            <input id="cacheManagerSelector"/>
          </li>
        </ul>
      </div>
      <div id="mainSplitter" style="width:100%;">
        <div id="topArea" style="height:100%;">
          <div id="splitter" style="height:100%;margin:0px;padding:0px;">
            <div id="leftArea" style="height:100%;margin:0px;padding:0px;">
              <div id="chartHeader">CacheManager Usage by Tier</div>
              <div id="chart" name="Local Heap"></div>
              <div id="chart" name="Local OffHeap"></div>
              <div id="chart" name="Local Disk"></div>
            </div>
            <div id="rightArea" style="height:100%;margin:0px;padding:0px;">
              <div id="chartHeader">Relative Cache Sizes by Tier</div>
              <div id="top" class="selector-controls">
                <ul style="float:left;">
                  <li>Tier:</li>
                  <li>
                    <select id="tierSelector">
                      <option>Local Heap</option>
                      <option>Local OffHeap</option>
                      <option>Local Disk</option>
                    </select>
                  </li>
                </ul>
              </div>
              <div id="grid"></div>
            </div>            
          </div>
        </div>
        <div id="bottomArea" style="height:100%;">
          <div id="bottomAreaHeader" class="k-content" style="margin-top:3px;">
            <b>Selected Cache:</b>&nbsp;<input id="cacheSelector"/>&nbsp;<span id="selectedCacheDescription"></span>
          </div>
          <div id="splitter">
            <div id="leftArea" style="height:100%;margin:0px;padding:0px;">
              <div id="chartHeader">Cache Usage by Tier</div>
              <div id="chart" name="Local Heap"></div>
              <div id="chart" name="Local OffHeap"></div>
              <div id="chart" name="Local Disk"></div>
            </div>
            <div id="rightArea" style="height:100%;margin:0px;padding:0px;">
              <div id="chartHeader">Cache Miss Rate by Tier</div>
              <div id="chart" name="Local Heap"></div>
              <div id="chart" name="Local OffHeap"></div>
              <div id="chart" name="Local Disk"></div>
            </div>            
          </div>
        </div>   
      </div>
    </div>
  </div>
</div>

<div id="config-window" style="display:none">
  <textarea id="config-text" rows="20" cols="60" readonly="readonly"></textarea>
</div>

<script id="topologyContentTemplate" type="text/kendo-ui-template">
  #= item.text #
  <a class='configLink' href='\\#'>config</a>
  <input type='hidden' name='#= item.text #' value='false'/>
</script>

<div id="configureColumnsWindow" style="display:none">
  <div id="msg" style='padding:1em;' class='k-content'>Select the statistics you would like to monitor.</div>
  <form id="configureColumnsForm">
    <div id="choices" class="k-content" style="overflow-y:scroll;height:25em;border:solid 1px #aacfe4;border-radius:5px;cursor:default;">
      <table cellspacing='1' cellpadding='3' border='0'>
        <tr title="Ratio of cache hits to sum of hits and misses"><td>
          <input type="checkbox" name="CacheHitRatio">Hit Ratio</input>
        </td></tr>
        <tr title="Cache hits per second"><td>
          <input type="checkbox" name="CacheHitRate">Hit Rate</input>
        </td></tr>
        <tr title="Disk hits per second"><td>
          <input type="checkbox" name="CacheOnDiskHitRate">Local Disk Hit Rate</input>
        </td></tr>
        <tr title="Heap hits per second"><td>
          <input type="checkbox" name="CacheInMemoryHitRate">Local Heap Hit Rate</input>
        </td></tr>
        <tr title="OffHeap hits per second"><td>
          <input type="checkbox" name="CacheOffHeapHitRate">OffHeap Hit Rate</input>
        </td></tr>

        <tr title="Cache misses per second"><td>
          <input type="checkbox" name="CacheMissRate">Miss Rate</input>
        </td></tr>
        <tr title="Disk misses per second"><td>
          <input type="checkbox" name="CacheOnDiskMissRate">Local Disk Miss Rate</input>
        </td></tr>
        <tr title="Heap misses per second"><td>
          <input type="checkbox" name="CacheInMemoryMissRate">Local Heap Miss Rate</input>
        </td></tr>
        <tr title="OffHeap misses per second"><td>
          <input type="checkbox" name="CacheOffHeapMissRate">OffHeap Miss Rate</input>
        </td></tr>

        <tr title="Cache entry count"><td>
          <input type="checkbox" name="Size">Size</input>
        </td></tr>
        <tr title="Heap entry count"><td>
          <input type="checkbox" name="LocalHeapSize">Local Heap Size</input>
        </td></tr>
        <tr title="Disk entry count"><td>
          <input type="checkbox" name="LocalDiskSize">Local Disk Size</input>
        </td></tr>
        <tr title="OffHeap entry count"><td>
          <input type="checkbox" name="LocalOffHeapSize">Local OffHeap Size</input>
        </td></tr>

        <tr title="Space taken by heap entries"><td>
          <input type="checkbox" name="LocalHeapSizeInBytes">Local Heap Bytes</input>
        </td></tr>
        <tr title="Space taken by disk entries"><td>
          <input type="checkbox" name="LocalDiskSizeInBytes">Local Disk Bytes</input>
        </td></tr>
        <tr title="Space taken by OffHeap entries"><td>
          <input type="checkbox" name="LocalOffHeapSizeInBytes">Local OffHeap Bytes</input>
        </td></tr>

        <tr title="Median get() millis."><td>
          <input type="checkbox" name="CacheAverageGetTime">Average Get Time</input>
        </td></tr>
        <tr title="Median search millis."><td>
          <input type="checkbox" name="CacheAverageSearchTime">Average Search Time</input>
        </td></tr>

        <tr title="Searches per second"><td>
          <input type="checkbox" name="CacheSearchRate">Search Rate</input>
        </td></tr>
        <tr title="Puts per second"><td>
          <input type="checkbox" name="CachePutRate">Put Rate</input>
        </td></tr>
        <tr title="Removes per second"><td>
          <input type="checkbox" name="CacheRemoveRate">Remove Rate</input>
        </td></tr>
        <tr title="Updates per second"><td>
          <input type="checkbox" name="CacheUpdateRate">Update Rate</input>
        </td></tr>
        <tr title="Entry expirations per second"><td>
          <input type="checkbox" name="CacheExpirationRate">Expiration Rate</input>
        </td></tr>
        <tr title="Entry evictions per second"><td>
          <input type="checkbox" name="CacheEvictionRate">Eviction Rate</input>
        </td></tr>

        <tr title="Txns. rolled-back per second"><td>
          <input type="checkbox" name="TransactionRollbackRate">Transaction Rollback Rate</input>
        </td></tr>
        <tr title="Txns. commited per second"><td>
          <input type="checkbox" name="TransactionCommitRate">Transaction Commit Rate</input>
        </td></tr>

        <tr title="Write-behind writer queue length"><td>
          <input type="checkbox" name="WriterQueueLength">Writer Queue Length</input>
        </td></tr>

<!--
        <tr><td><input type="checkbox" name="EvictedCount">Evicted Count</input></td></tr>
        <tr><td><input type="checkbox" name="InMemoryHitCount">Local Heap Hit Count</input></td></tr>
        <tr><td><input type="checkbox" name="InMemoryMissCount">Local Heap Miss Count</input></td></tr>
        <tr><td><input type="checkbox" name="XaRollbackCount">XA Rollback Count</input></td></tr>
        <tr><td><input type="checkbox" name="CacheMissCount">Miss Count</input></td></tr>
        <tr><td><input type="checkbox" name="XaCommitCount">XA Commit Count</input></td></tr>
        <tr><td><input type="checkbox" name="CacheHitCount">Hit Count</input></td></tr>
        <tr><td><input type="checkbox" name="ExpiredCount">Expired Count</input></td></tr>
        <tr><td><input type="checkbox" name="PutCount">Put Count</input></td></tr>
        <tr><td><input type="checkbox" name="RemovedCount">Removed Count</input></td></tr>
        <tr><td><input type="checkbox" name="OffHeapHitCount">OffHeap Hit Count</input></td></tr>
        <tr><td><input type="checkbox" name="OffHeapMissCount">OffHeap Miss Count</input></td></tr>
        <tr><td><input type="checkbox" name="OnDiskHitCount">Local Disk Hit Count</input></td></tr>
        <tr><td><input type="checkbox" name="OnDiskMissCount">Local Disk Miss Count</input></td></tr>
        <tr><td><input type="checkbox" name="CacheMissCountExpired">Miss Count Expired</input></td></tr>
-->
      </table>
    </div>
    <div id="SelectAllArea" style="float:right;display:none;border-top:3px;">
      <input type="checkbox" id="SelectAllControl">Select All</input>
    </div>
    <table cellspacing='1' cellpadding='3' border='0' style='width:100%'>
      <tr>
        <td width='50%' align='right'>
          <button type='button' id='okButton' class='k-button' style='width:100px;'
            title='Apply changes and close window'>OK</button>
        </td>
        <td width='50%'>
          <button type='button' id='cancelButton' class='k-button' style='width:100px;'
            title='Ignore changes and close window'>Cancel</button>
        </td>
      </tr>
    </table>
  </form>
</div>

<div id="editCacheConfigWindow" style="display:none">
  <table cellspacing='1' cellpadding='3' border='0'>
    <tr>
      <td style="text-align:right;">MaxElementsOnDisk</td>
      <td>
        <input id="MaxElementsOnDisk" type="number" value="0" min="0" step="1000"/>
      </td>
    </tr>
    <tr>
      <td style="text-align:right;">MaxBytesLocalDisk</td>
      <td>
        <input id="MaxBytesLocalDiskAsString" type="text" class="k-textbox" placeholder="Example: 30M"/>
      </td>
    </tr>
    <tr>
      <td style="text-align:right;">MaxBytesLocalHeap</td>
      <td>
        <input id="MaxBytesLocalHeapAsString" type="text" class="k-textbox" placeholder="Example: 3000000"/>
      </td>
    </tr>
    <tr>
      <td style="text-align:right;">MaxEntriesLocalHeap</td>
      <td>
        <input id="MaxEntriesLocalHeap" type="number" value="0" min="0" step="1000"/>
      </td>
    </tr>
    <tr>
      <td style="text-align:right;">TimeToIdleSeconds</td>
      <td>
        <input id="TimeToIdleSeconds" type="number" value="0" min="0" step="10"/>
      </td>
    </tr>
    <tr>
      <td style="text-align:right;">TimeToLiveSeconds</td>
      <td>
        <input id="TimeToLiveSeconds" type="number" value="0" min="0" step="10"/>
      </td>
    </tr>
  </table>
  <br/>
  <table cellspacing='1' cellpadding='3' border='0' style='width:100%'>
    <tr>
      <td width='50%' align='right'>
        <button type='button' id='okButton' class='k-button' style='width:100px;'
          title='Apply changes and close window'>OK</button>
      </td>
      <td width='50%'>
        <button type='button' id='cancelButton' class='k-button' style='width:100px;'
          title='Ignore changes and close window'>Cancel</button>
      </td>
    </tr>
  </table>
</div>

<div id="editCacheManagerConfigWindow" style="display:none">
  <table cellspacing='1' cellpadding='3' border='0'>
    <tr>
      <td style="text-align:right;">MaxBytesLocalDisk</td>
      <td>
        <input id="MaxBytesLocalDiskAsString" type="text" class="k-textbox" placeholder="Example: 30M"/>
      </td>
    </tr>
    <tr>
      <td style="text-align:right;">MaxBytesLocalHeap</td>
      <td>
        <input id="MaxBytesLocalHeapAsString" type="text" class="k-textbox" placeholder="Example: 3000000"/>
      </td>
    </tr>
  </table>
  <br/>
  <table cellspacing='1' cellpadding='3' border='0' style='width:100%'>
    <tr>
      <td width='50%' align='right'>
        <button type='button' id='okButton' class='k-button' style='width:100px;'
          title='Apply changes and close window'>OK</button>
      </td>
      <td width='50%'>
        <button type='button' id='cancelButton' class='k-button' style='width:100px;'
          title='Ignore changes and close window'>Cancel</button>
      </td>
    </tr>
  </table>
</div>
