function SettingsManager() {
  var that = this;
  this.$window = $("#manageSettingsWindow");
  this.kWindow = this.$window.kendoWindow({
    title: "Manage Settings",
    actions: ["Close"],
    width: "36em",
    height: "auto",
    visible: false,
    resizable: false,
    modal: true,
    animation: false
  }).data("kendoWindow");
  var numberInputConfig = {format: "n0"};
  this.kPollIntervalSeconds = this.$window.find("#pollIntervalSeconds").kendoNumericTextBox(numberInputConfig).data("kendoNumericTextBox");
  this.kAuthenticationEnabled = this.$window.find("#authenticationEnabled");
  this.confirmChangesWindow = this.$window.find("#confirmAuthChangesWindow");
  
  
  this.$window.on("click", "button[id='resetToDefaults']", function() {
    that.resetToDefaults();
  });  
  this.$window.on("click", "a[id='resetToDefaults']", function() {
	    that.resetToDefaults();
	  });
  
  this.$window.on("click", "a[id='resetToPrevious']", function() {
    that.resetToPrevious();
  });
  
  this.$window.on("click", "button[id='cancelButton']", function() {
    that.kWindow.close();
  });
  this.$window.on("click", "button[id='okButton']", function() {
   that.persistSettings();
  });

  this.$window.on("click", "button[id='okButtonAuthentication']", function(e) {
    //if there is no changes, nothing todo
    if(that.kAuthenticationEnabled.is(':checked') == authenticationEnabled){
      that.kWindow.close();
      return;
    }

    var confirmWindow = that.confirmChangesWindow;
    var kConfirmWindow = confirmWindow.kendoWindow({
      title: "Save Changes",
      width: "28em",
      visible: false,
      resizable: false,
      modal: true,
      animation: false
    }).data("kendoWindow");
    
    confirmWindow.find("#ok").click(function() {
      that.persistSettingsAuthentication();
      kConfirmWindow.close();
      kConfirmWindow.destroy();
    });
    confirmWindow.find("#cancel").click(function() {
      kConfirmWindow.close();
//      kConfirmWindow.destroy();
    });
    
    confirmWindow.show();
    kConfirmWindow.center();
    kConfirmWindow.open();
    kConfirmWindow.toFront();
    
    e.preventDefault();
    e.stopPropagation();
  });
  
  var keydownHandler = function(e) {
    switch (e.which) {
      case kendo.keys.ESC: {
        that.kWindow.close();
        break;
      }
      case kendo.keys.ENTER: {
        that.$window.find("button[id='okButton']").click();
        break;
      }
    }
  };
  this.kWindow.bind("open", function() {
    $(document).bind("keydown", keydownHandler);
  });
  this.kWindow.bind("close", function() {
    $(document).unbind("keydown", keydownHandler);
  });
}

SettingsManager.prototype = {
  show: function() {
    this.$window.show();
    this.kWindow.center();
    this.kWindow.open();
    this.setup();
    this.setupAuthentication();
  },
  
  hide: function() {
    this.kWindow.close();
  },
  
  setup: function() {
    if (userProfile != null) {
      this.kPollIntervalSeconds.value(userProfile.statisticsPollingIntervalMillis/1000);
    } else {
      this.resetToDefaults();
    }
  },

  setupAuthentication : function() {
		if (authenticationEnabled != null && authenticationEnabled == true) {
			this.kAuthenticationEnabled.attr('checked', true);
		} else {
			this.kAuthenticationEnabled.attr('checked', false);
		}
	},
  
  resetToDefaults: function() {
    this.kPollIntervalSeconds.value(5);
  },
  
  resetToPrevious: function() {
    this.kAuthenticationEnabled.attr('checked', authenticationEnabled);
  },
  
  persistSettings: function() {
    var that = this;
    
    userProfile.statisticsPollingIntervalMillis = (this.kPollIntervalSeconds.value() * 1000);
    updateUserProfile(userProfile).done(function() {
      that.hide();
    });
  },
  
  persistSettingsAuthentication: function() {
    var that = this;
    updateAuthentication(this.kAuthenticationEnabled.is(':checked')).done(function() {
      that.hide();
    });
  }
};
