function NavigatorPage($content) {
  this.$content = $content;
}

NavigatorPage.prototype = {
  bind: function(eventMap) {
    $.each(eventMap, function(eventType, handler) {
      this.bind(eventType, handler);
    });
  },
  
  bind: function(eventType, handler) {
    this.$content.bind(eventType, handler);
  },

  unbind: function(eventType, handler) {
    this.$content.unbind(eventType, handler);
  },
  
  trigger: function(e) {
    this.$content.trigger(e);
  },

  fireEvent: function(eventType, object) {
    var event = jQuery.Event(eventType);
    if (object) {
      $.extend(event, object);
    }
    this.trigger(event);
  },
  
  getPollIntervalSeconds: function() {
    return null;
  }
};
