function NavigatorGroupPage(group) {
  NavigatorPage.call(this, $("#navigator-group .navigator-group").clone());
  var that = this;
  this.group = group;
  this.$liveConnectionsContent = this.$content.find("#liveConnectionsContent");
  this.$unavailableContent = this.$content.find("#unavailableContent");
  this.$tabStrip = this.$content.find("#tabstrip").kendoTabStrip({
    animation: {
      open:  {effects: false},
      close: {effects: false}
    }
  });
  var dataSourceConfig = function() {
    return {
      data: [],
      schema: {
        model: {
          id: "connection",
          fields: {
            connection: {type: "string", editable: false},
            location: {type: "string", editable: false},
            secured: {type: "boolean", editable: false},
            enabled: {type: "boolean", editable: true}
          }
        }
      },
      sort: {field: "connection", dir: "asc"}
     };
  };
  this.liveConnectionsGridDS = new kendo.data.DataSource(dataSourceConfig());
  this.liveConnectionsGrid = this.$liveConnectionsContent.find("#grid_l").kendoTGrid({
    dataSource: this.liveConnectionsGridDS,
    columns: [
      {
        title: "Connections to EHCACHE",
        field: "connection"
      },
      {
        title: "Location",
        field: "location", 
        template: "<span class=#=secured ? 'securityOn' : 'securityOff'#>#= location #</span>"
      },
      {
        title: "State",
        field: "enabled", 
        template: "#= enabled ? 'enabled' : 'disabled' #",
        editor: function(container, options) {
          if (options.model.enabled) {
            $("<button name='" + options.field + "' type='button' class='k-button'>Disable</button>")
            .appendTo(container);
          } else {
            $("<button name='" + options.field + "' type='button' class='k-button enable-connection'>Enable</button>")
            .appendTo(container);
          }
        }
      }
    ],
    selectable: "row",
    sortable: true,
    pageable: false,
    scrollable: true,
    resizable: true,
    editable: "incell"
  });
  
  this.unavailableGridDS = new kendo.data.DataSource(dataSourceConfig());
  this.unavailableGrid = this.$unavailableContent.find("#grid_u").kendoTGrid({
    dataSource: this.unavailableGridDS,
    columns: [
      {
        title: "Connection",
        field: "connection",
        template: "<a class='editConnectionLink' href='\\#'>#= connection #</a>"
      },
      {
        title: "Location",
        field: "location",
        template: "<span class=#=secured ? 'securityOn' : 'securityOff'#>#= location #</span>"
      },
      {
        title: "State",
        field: "enabled", 
        template: "#= enabled ? 'enabled' : 'disabled' #",
        editor: function(container, options) {
          if (options.model.enabled) {
            $("<button name='" + options.field + "' type='button' class='k-button'>Disable</button>")
            .appendTo(container);
          } else {
            $("<button name='" + options.field + "' type='button' class='k-button enable-connection'>Enable</button>")
            .appendTo(container);
          }
        }
      }
    ],
    selectable: "row",
    sortable: true,
    pageable: false,
    scrollable: true,
    resizable: true,
    editable: "incell"
  });
  
  var stateHandler = function(e) {
    var $this = $(this),
      $grid = $this.closest(".k-grid"),
      kGrid = $grid.data("kendoTGrid"),
      entry = kGrid.dataItem($this.closest("tr"));

    if (entry != null) {
      $this.text("Wait...");
      
      var connection = connections[that.group][entry.connection];
      connection.enabled = $this.hasClass("enable-connection");
      connectionManager.updateConnection(connection.getId(), connection)
        .done(function() {
          connectionManager.persistConnections()
            .always(function() {
              if (kGrid.editable) {
                kGrid.closeCell();
              }
            });
        })
        .always(function() {
          if (kGrid.editable) {
            kGrid.closeCell();
          }
        });
    }
  };
  that.liveConnectionsGrid.on("click", "button[name='enabled']", stateHandler);
  that.unavailableGrid.on("click", "button[name='enabled']", stateHandler);

  resizeHandler(this.$content, function(e) {
    assignRemainingHeight(that.$tabStrip);    
    var pageHeight = that.$tabStrip.height() - that.$tabStrip.find(".k-tabstrip-items").outerHeight(true);
    that.$tabStrip.children(".k-content").filter(":visible").height(pageHeight);
    
    assignRemainingHeight(that.liveConnectionsGrid);
    that.liveConnectionsGrid.data("kendoTGrid")._setContentHeight();

    assignRemainingHeight(that.unavailableGrid);
    that.unavailableGrid.data("kendoTGrid")._setContentHeight();
  });
}

NavigatorGroupPage.prototype = $.extend({}, NavigatorPage.prototype, {
  show: function() {
    var that = this;
    $contentArea.append(this.$content); 
    this.$content.show();
    this.$content.on("click", ".editConnectionLink", function(e) {
      e.preventDefault();
      window.connectionManager.editConnection(that.group, $(this).text());
    });
  },  
 
  hide: function() {
    this.$content = $contentArea.find(".navigator-group").detach();
    this.$content.off('click');
  },

  handleResponse: function(data) {
    var that = this,
      unavailable = {},
      available = {},
      liveGridDS = this.liveConnectionsGridDS,
      unavailableGridDS = this.unavailableGridDS,
      agentConnections = {},
      connectionUpdateRequests = [];
    
    $.each(data, function(i, value) {
      var agentId = value.agentId,
        agentIdComps = agentId.split("_"),
        agentGroup = agentIdComps[0],
        connectionName = agentIdComps[1];
      
      if (agentGroup == that.group) {
        var connection = connections[that.group][connectionName];

        connection.secured = value.secured;
        agentConnections[connectionName] = {
          restAPIVersion: value.restAPIVersion,
          available: value.available,
          connection: connectionName,
          location: connection.agentLocation,
          secured: connection.secured,
          enabled: connection.enabled
        };
      }
    });

    $.each(agentConnections, function(connectionName, entry) {
      var $grid,
        ds;
   
      if (entry.available) {
        $grid = that.liveConnectionsGrid;
        ds = liveGridDS;
        available[connectionName] = entry;
      } else {
        $grid = that.unavailableGrid;
        ds = unavailableGridDS;
        unavailable[connectionName] = entry;
      }
      
      if (ds.get(connectionName) == null) {
        var connection = connections[that.group][connectionName];
        connectionUpdateRequests.push(connectionManager.updateConnection(connection.getId(), connection));
      }

      $grid.data("kendoTGrid").updateModel(connectionName, entry);
    });

    if (connectionUpdateRequests.length > 0) {
      $.when.apply($, connectionUpdateRequests).always(function() {
        connectionManager.persistConnections();
      });
    }
    
    // Remove orphans
    
    for (var i = 0; i < unavailableGridDS.total(); i++) {
      var item = unavailableGridDS.at(i);
      if (unavailable[item.connection] == null) {
        that.unavailableGrid.data("kendoTGrid").removeModel(item.connection);
      }
    }
    
    for (var i = 0; i < liveGridDS.total(); i++) {
      var item = liveGridDS.at(i);
      if (available[item.connection] == null) {
        that.liveConnectionsGrid.data("kendoTGrid").removeModel(item.connection);
      }
    }

    this._testForEmpty(that.liveConnectionsGrid);
    this._testForEmpty(that.unavailableGrid);

    liveGridDS.fetch();
    unavailableGridDS.fetch();
  },
   
  _testForEmpty: function($grid) {
    var isEmpty = ($grid.data("kendoTGrid").dataSource.total() == 0),
      $span = $grid.siblings("span");
    
    if (isEmpty && $grid.is(":visible")) {
      $grid.hide();
      $span.show();
    } else if (!isEmpty && $span.is(":visible")) {
      $span.hide();
      $grid.show();
    }
  },
  
  refresh: function() {
    var that = this;
    var jqxhr = $.ajax({
      type: "GET",
      url: encodeURI("api/agents/info"),
      success: $.proxy(that.handleResponse, that),
      dataType: "json"
    }).error(function(jqXHR, textStatus, errorThrown) {
      var msg = "Failed to load agents";
      handleError(msg, jqXHR, textStatus, errorThrown);
    }).always(function() {
      that.fireEvent("tmc.responseComplete");
    });
  }
});
