function NavigatorAgentPage(name, groupId, category) {
  NavigatorPage.call(this, $("#navigator-agent .navigator-agent").clone());
  
  var that = this;
  this.name = name;
  this.groupId = groupId;
  this.id = groupId + "_" + name;
  this.category = category;
  
  this.pages = {};
  this.pages.overviewContent = new AgentTopologyPage(this, this.$content.find("#overviewContent"));
  this.pages.monitoringContent = new AgentMonitoringPage(this, this.$content.find("#monitoringContent"));
  if (window.inAdminRole == true) {
    this.pages.managementContent = new AgentManagementPage(this, this.$content.find("#managementContent"));
  }
  this.pages.diagnosticsContent = new AgentDiagnosticsPage(this, this.$content.find("#diagnosticsContent"));
  
  this.$tabStrip = this.$content.find("#tabstrip").kendoTabStrip({
    animation: false,
    select: $.proxy(this.handleTabSelection, this)
  });

  this._handleQueryAttributesChanged = $.proxy(that.handleQueryAttributesChanged, this);
  this.CACHE_MANAGER_ATTRIBUTES = ["CacheNames"];

  this.cacheManagers = {}; /* name -> attributes */

  resizeHandler(this.$content, function(e) {
    var pageHeight = that.$tabStrip.height() - that.$tabStrip.find(".k-tabstrip-items").outerHeight(true);
    that.$tabStrip.children(".k-content").filter(":visible").height(pageHeight);    
  });
  
  this.requestStatisticsSettings().done(function(data) {
    var that = this,
      agentId = this.getId();
    
    $.each(data, function(index, info) {
      if (agentId === info.agentId) {
        that.sampleIntervalSeconds = info.sampleIntervalSeconds;
        that.sampleHistorySize = info.sampleHistorySize;
        return false;
      }
    });
  }).fail(function(jqXHR, textStatus, errorThrown) {
    alert("Failed to retrieve agent statistics settings: " + textStatus);
  }).always(function() {
    that.pages.monitoringContent.initialize();
  });
}
  
NavigatorAgentPage.prototype = $.extend({}, NavigatorPage.prototype, {
  getAgentConfig: function() {
    return window.connections[this.groupId][this.name];
  },
  
  getPollIntervalSeconds: function() {
    return this.sampleIntervalSeconds;
  },

  getSampleHistorySize: function() {
    return this.sampleHistorySize;
  },
  
  requestStatisticsSettings: function() {
    return $.ajax({
      type: "GET",
      url: encodeURI("api/agents/info"),
      context: this,
      dataType: "json",
      cancelable: false
    });
  },
  
  refreshQueryAttributes: function(page) {
    if (page) {
      this.updateQueryAttributes(page.getQueryAttributes());
    } else {
      this.queryAttributes = {};
    }
  },
  
  updateQueryAttributes: function(queryAttrs) {
    var cacheManagerAttrs = this.CACHE_MANAGER_ATTRIBUTES;
      pageCacheManagerAttrs = queryAttrs["cacheManagerAttributes"];
  
    if (pageCacheManagerAttrs) {
      cacheManagerAttrs = concatUnique(pageCacheManagerAttrs, cacheManagerAttrs);
    }
    queryAttrs["cacheManagerAttributes"] = cacheManagerAttrs;
    
    this.queryAttributes = queryAttrs;
  },
  
  handleQueryAttributesChanged: function(e) {
    this.updateQueryAttributes(e.queryAttributes);
  },
  
  show: function() {
    $contentArea.append(this.$content);
    this.$content.show();

    var currentPage = this.getCurrentPage();
    if (currentPage) {
      this.showPage(currentPage);
    }
  },  
 
  hide: function() {
    var currentPage = this.getCurrentPage();
    if (currentPage) {
      this.hidePage(currentPage);
    }
    
    this.$content = $contentArea.find(".navigator-agent").detach();
  },
  
  getCurrentPage: function() {
    var item = this.$tabStrip.data("kendoTabStrip").select(),
      id = $(item).attr("id");
    
    return this.pages[id + "Content"];
  },
  
  handleTabSelection: function(e) {
    var currentPage = this.getCurrentPage(),
      id = $(e.item).attr("id"),
      page = this.pages[id + "Content"];

    if (currentPage) {
      this.hidePage(currentPage);
    }
    if (page) {
      this.showPage(page)
    }
  },
  
  bindEvents: function(page) {
    page.bind("ehcache.query.attributes", this._handleQueryAttributesChanged);
  },
  
  unbindEvents: function(page) {
    page.unbind("ehcache.query.attributes", this._handleQueryAttributesChanged);
  },

  hidePage: function(page) {
    this.unbindEvents(page);
    page.hide();
  },
  
  showPage: function(page) {
    page.show();
    this.bindEvents(page);
    this.refreshQueryAttributes(page);
  },
  
  getId: function() {
    return this.id;
  },

  handleCacheDetailsResponse: function(cacheManagerName, data) {
    var cacheManagerAttrs = this.cacheManagers[cacheManagerName]

    cacheManagerAttrs.caches = {};
    $.each(data, function(index, value) {
      value.attributes.CacheName = value.name;
      cacheManagerAttrs.caches[value.name] = value.attributes;
    });
    
    this.fireEvent("ehcache.cacheDetails", {cacheManagerName: cacheManagerName});
  },
  
  handleCacheManagersResponse: function(data) {
    var that = this,
      cacheManagerMap = {},
      queryAttrs = {},
      requestCacheDetails = true,
      detailRequests = [];
    
    if (this.queryAttributes) {
      queryAttrs = this.queryAttributes;
      if (queryAttrs.cacheDetails === false) {
        requestCacheDetails = false;
      }
    }
    
    $.each(data, function(index, value) {
      var cacheManagerName = value.name,
        cacheManagerAttrs =  that.cacheManagers[cacheManagerName], 
        existingCaches = cacheManagerAttrs != null ? cacheManagerAttrs.CacheNames : null,
        newCacheNames = value.attributes.CacheNames;

      if (cacheManagerAttrs) {
        $.extend(cacheManagerAttrs, value.attributes);
      } else {
        that.cacheManagers[cacheManagerName] = value.attributes;
        that.fireEvent("ehcache.cacheManagerAdded", {cacheManagerName: cacheManagerName});
      }
      cacheManagerMap[cacheManagerName] = newCacheNames;

      if (existingCaches == null) {
        var items = [];
        $.each(newCacheNames, function(idx, cacheName) {
          items.push({text: cacheName});
        });
        alphaSort(items, "text");
        items = $.map(items, function(value, key) { return value.text; });
        that.fireEvent("ehcache.cachesAdded", {
          cacheManagerName: cacheManagerName,
          cacheNames: items
        });
      } else {
        var cacheMap = {};
        
        $.each(newCacheNames, function(i, cacheName) {
          cacheMap[cacheName] = cacheName;

          if ($.inArray(cacheName, existingCaches) == -1) {
            existingCaches.push(cacheName);
            that.fireEvent("ehcache.cacheAdded", {
              cacheManagerName: cacheManagerName,
              cacheName: cacheName
            });
          }
        });

        $.each(existingCaches, function(index, existingCacheName) {
          if (cacheMap[existingCacheName] == null) {
            delete existingCaches[index];
            that.fireEvent("ehcache.cacheRemoved", {cacheName: existingCacheName});
          }
        });
      }

      if (requestCacheDetails &&
          (queryAttrs.cacheManager == null || cacheManagerName == queryAttrs.cacheManager))
      {
        var jqxhr = $.ajax({
          type: "GET",
          url: encodeURI(that.buildCacheDetailsRequest(cacheManagerName)),
          success: function(data) {
            this.handleCacheDetailsResponse(cacheManagerName, data);
          },
          context: that,
          dataType: "json"
        });
        detailRequests.push(jqxhr);
      }
    });
    
    $.each(that.cacheManagers, function(cacheManagerName, cacheManagerAttrs) {
      if (cacheManagerMap[cacheManagerName] == null) {
        delete that.cacheManagers[cacheManagerName];
        that.fireEvent("ehcache.cacheManagerRemoved", {cacheManagerName: cacheManagerName});
      }
    });
    
    if (requestCacheDetails) {
      $.when.apply($, detailRequests).always(function() {
        that.fireEvent("tmc.responseComplete");
      });
    } else {
      that.fireEvent("tmc.responseComplete");
    }
  },
  
  buildCacheManagerRequest: function() {
    var suffix = "";
    
    if (this.queryAttributes) {
      var queryAttrs = this.queryAttributes;

      if (queryAttrs.cacheManagerAttributes) {
        suffix += "?show=" + queryAttrs.cacheManagerAttributes.join("&show=");
      }
    }
    return "api/agents;ids=" + this.getId() + "/cacheManagers" + suffix;
  },
  
  buildCacheDetailsRequest: function(cacheManagerName) {
    var suffix = "";
    
    if (this.queryAttributes) {
      var queryAttrs = this.queryAttributes;
      
      if (queryAttrs.cache) {
        suffix = ";names=" + queryAttrs.cache;
      }
      if (queryAttrs.cacheAttributes) {
        suffix += "?show=" + queryAttrs.cacheAttributes.join("&show=");
      }
    }
    return "api/agents;ids=" + this.getId() + "/cacheManagers;names=" + cacheManagerName + "/caches" + suffix;
  },
  
  refresh: function() {
    if (this.$content.is(":visible")) {
      var jqxhr = $.ajax({
        type: "GET",
        url: encodeURI(this.buildCacheManagerRequest()),
        success: this.handleCacheManagersResponse,
        context: this,
        dataType: "json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        var msg = "Failed to load cacheManagers";
        handleError(msg, jqXHR, textStatus, errorThrown);
      });
    }
  }
});
