function AgentTopologyPage(agentPage, $content) {
  BaseAgentPage.call(this, agentPage, $content);

  var that = this;
  this.$topology = $content.find("#topology");
  this.$healthMetrics = $content.find("#healthMetrics");
  this.$topology2 = $content.find("#topology2");
  this.$healthMetrics2 = $content.find("#healthMetrics2");
  $content.find("#healthMetricsButton").click($.proxy(this.showHealthMetrics, this));
  this.$topologyContent = $content.find("#topologyContent").kendoTTreeView({
    template: kendo.template($("#navigator-agent #topologyContentTemplate").html()),
    select: function(e) {
      that.$topologyContent.find(".configLink").hide();
      $(e.node).children().first().find(".configLink").show();
    }
  });
  $content.find("#topologyButton").click($.proxy(this.showTopology, this));
  this.healthMetricsGridDS = new kendo.data.DataSource({
    data: [],
    schema: {
      model: {
        id: "name",
        fields: {
          name:         {type: "string", editable: false},
          status:       {type: "string", editable: false},
          hitRate:      {type: "number", editable: false},
          elementCount: {type: "number", editable: false},
          offHeapUsage: {type: "number", editable: false}
        }
      }
    },
    sort: {field: "name", dir: "asc"}
  });
  this.$healthMetricsGrid = this.$healthMetrics.find("#grid").kendoTGrid({
    dataSource: this.healthMetricsGridDS,
    columns: [
      {
        title: "CacheManager",
        field: "name",
        width: "40%"
      },
      {
        title: "Status",
        field: "status",
        width: "15%"
      },
      {
        title: "Hit Rate (hits/s)",
        field: "hitRate",
        template: '#= formatIntRightJustified(hitRate) #',
        width: "15%"
      },
      {
        title: "Element Count",
        field: "elementCount",
        template: '#= formatIntRightJustified(elementCount) #',
        width: "15%"
      },
      {
        title: "OffHeap Usage",
        field: "offHeapUsage",
        template: '#= formatPercentageRightJustified(offHeapUsage) #',
        width: "15%"
      }
    ],
    sortable: true,
    pageable: false,
    scrollable: true,
    resizable: true,
    reorderable: true,
    selectable: "row",
    detailInit: $.proxy(this.healthMetricsDetailInit, this)
  });
  this.expandedCacheManagers = {};
  this.$configWindow = $("#navigator-agent #config-window").clone().kendoWindow({
    height: "auto",
    width: "auto",
    modal: false,
    animation: false,
    resizable: false,
    visible: false,
    title: "CacheManager Configuration",
    actions: ['Close']
  });
  this.kConfigWindow = this.$configWindow.data("kendoWindow");

  this.CACHE_ATTRIBUTES = [
    "Status",
    "Size",
    "CacheHitRate",
    "TerracottaClustered",
    "MaxBytesLocalOffHeap",
    "LocalOffHeapSizeInBytes"
  ];

  this.CACHE_MANAGER_ATTRIBUTES = [
    "Status",
    "CacheHitRate",
    "MaxBytesLocalOffHeap"
  ];

  this.EMPTY_ATTRIBUTES = [];

  resizeHandler($content, function(e) {
    var $target = that.$healthMetrics.is(":visible") ? that.$healthMetrics : that.$topology;
    assignRemainingHeight($target);
  });

  resizeHandler(that.$healthMetrics, function(e) {
    that.$healthMetricsGrid.data("kendoTGrid")._setContentHeight();
  });

  var xsl_string = '<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" exclude-result-prefixes="#default">\
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>\
    <xsl:strip-space elements="*"/>\
    <xsl:template match="@*|node()">\
    <xsl:copy>\
    <xsl:apply-templates select="@*|node()"/>\
  </xsl:copy>\
  </xsl:template>\
    </xsl:stylesheet>';
  this.xsl = (new DOMParser()).parseFromString(xsl_string, "text/xml");
}

AgentTopologyPage.prototype = $.extend({}, BaseAgentPage.prototype, {
  toString: function() {
    return "AgentTopologyPage";
  },

  isMetricsShowing: function() {
    return this.$healthMetrics2.hasClass("toggleOn");
  },

  getCacheAttributes: function() {
    return this.isMetricsShowing() ? this.CACHE_ATTRIBUTES : this.EMPTY_ATTRIBUTES;
  },

  getCacheManagerAttributes: function() {
    return this.isMetricsShowing() ? this.CACHE_MANAGER_ATTRIBUTES : this.EMPTY_ATTRIBUTES;
  },

  getCacheDetails: function() {
    return this.isMetricsShowing();
  },

  healthMetricsDetailInit: function(e) {
    this.exposeCaches(e.data.name, e.detailCell);
  },

  showHealthMetrics: function() {
    var that = this;

    $.xhrPool.suspend();
    that.$topology2.attr('class', 'toggleOff');
    that.$healthMetrics2.attr('class', 'toggleOn');
    that.$topology.fadeOut('fast', function() {
      that.fireQueryAttributesChanged();
      $.xhrPool.resume();
      that.$healthMetrics.fadeIn();
    });
  },

  showTopology: function() {
    var that = this;

    $.xhrPool.suspend();
    that.$healthMetrics2.attr('class', 'toggleOff');
    that.$topology2.attr('class', 'toggleOn');
    that.$healthMetrics.fadeOut('fast', function() {
      that.fireQueryAttributesChanged();
      $.xhrPool.resume();
      that.$topology.fadeIn();
    });
  },

  xmlToString: function(xml) {
    if (window.ActiveXObject) {
      return xml;
    } else {
      return (new XMLSerializer()).serializeToString(xml);
    }
  },

  beautifyXml: function(xml) {
    var transformedXml = this.xslTransformation(xml, this.xsl);
    return this.xmlToString(transformedXml);
  },

  xslTransformation: function(xml, xsl) {
    if (window.ActiveXObject) {
      var xmldoc = new ActiveXObject("Microsoft.XMLDOM");
      xmldoc.async = false;
      xmldoc.loadXML(xml.outerHTML);
      var xsldoc = new ActiveXObject("Microsoft.XMLDOM");
      xsldoc.async = false;
      xsldoc.load(xsl);
      var ex = xmldoc.transformNode(xsldoc);
      return ex;
    } else if (document.implementation && document.implementation.createDocument) {
      var xsltProcessor = new XSLTProcessor();
      xsltProcessor.importStylesheet(xsl);
      var resultDocument = xsltProcessor.transformToDocument(xml, document);
      console.log(resultDocument);
      return resultDocument;
    }
  },

  show: function() {
    var that = this;
    $contentArea.on("click", ".configLink", function(e) {
      e.preventDefault();
      that.displayConfig($(this).closest(".k-item"));
    });
    BaseAgentPage.prototype.show.call(this);
  },

  hide: function() {
    BaseAgentPage.prototype.hide.call(this);
    $contentArea.off("click", ".configLink");
  },

  displayConfig: function($node) {
    var name = $node.find("input:first").attr("name");

    if ($node.parent().hasClass("k-treeview-lines")) {
      this.displayCacheManagerConfig(name);
    } else {
      var $parent = $node.parent().closest("li");
      var cacheManagerName = $parent.find("input:first").attr("name");
      this.displayCacheConfig(name, cacheManagerName);
    }
  },

  displayCacheManagerConfig: function(cacheManagerName) {
    var that = this;
    var jqxhr = $.ajax({
      type: "GET",
      url: encodeURI("api/agents;ids=" + this.agentPage.getId() + "/cacheManagers;names="
        + cacheManagerName + "/configs"),
      success: function(data) {
        that.handleCacheManagerConfigResponse(cacheManagerName, data);
      },
      dataType: "text"
    }).error(function(jqXHR, textStatus, errorThrown) {
        var msg = "Failed to load CacheManager configuration";
        handleError(msg);
      });
  },

  handleCacheManagerConfigResponse : function(name, configText) {
    var $ehcache = $(configText).find("ehcache");
    var $xml = $ehcache.get(0);
    var txt = this.beautifyXml($xml);
    txt = vkbeautify.xml(txt);
    this.$configWindow.find("textarea").val(txt);
    this.$configWindow.show();
    this.kConfigWindow.title("CacheManager Configuration: " + name);
    this.kConfigWindow.center();
    this.kConfigWindow.open();
    this.kConfigWindow.toFront();
  },

  displayCacheConfig: function(cacheName, cacheManagerName) {
    var that = this;
    var jqxhr = $.ajax({
      type: "GET",
      url: encodeURI("api/agents;ids=" + this.agentPage.getId() + "/cacheManagers;names="
        + cacheManagerName + "/caches;names=" + cacheName + "/configs"),
      success: function(data) {
        that.handleCacheConfigResponse(cacheName, data);
      },
      dataType: "text"
    }).error(function(jqXHR, textStatus, errorThrown) {
        var msg = "Failed to load Cache configuration";
        switch (jqXHR.status) {
          case 12029:
            msg += "; a connection to the server could not be created";
            break;
          default:
            msg += "; " + errorThrown;
        }
        alert(msg);
      });
  },

  handleCacheConfigResponse : function(name, configText) {
    var $ehcache = $(configText).find("configuration");
    var $xml = $ehcache.get(0);
    var txt = this.beautifyXml($xml);
    txt = vkbeautify.xml(txt);
    this.$configWindow.find("textarea").val(txt);
    this.$configWindow.show();
    this.kConfigWindow.title("Cache Configuration: " + name);
    this.kConfigWindow.center();
    this.kConfigWindow.open();
    this.kConfigWindow.toFront();
  },

  handleCachesAdded: function(e) {
    var kTopologyTree = this.$topologyContent.data("kendoTTreeView"),
      items = [];

    $.each(e.cacheNames, function(index, value) {
      items.push({text: value});
    });
    kTopologyTree.append({text: e.cacheManagerName, items: items});
  },

  handleCacheAdded: function(e) {
    var $cacheManagerNode = this.findCacheManagerNode(e.cacheManagerName),
      kTopologyTree = this.$topologyContent.data("kendoTTreeView");

    kTopologyTree.append({text: e.cacheName}, $cacheManagerNode);
  },

  handleCacheRemoved: function(e) {
    this.removeCacheNode(e.cacheName, e.cacheManagerName);
    if (this.expandedCacheManagers[e.cacheManagerName]) {
      this.removeExposedCache(e.cacheManagerName, e.cacheName);
    }
  },

  handleCacheManagerAdded: function(e) {},

  handleCacheManagerRemoved: function(e) {
    if (this.expandedCacheManagers[e.cacheManagerName]) {
      delete this.expandedCacheManagers[e.cacheManagerName];
    }
    this.removeCacheManagerNode(e.cacheManagerName);
    this.$healthMetricsGrid.data("kendoTGrid").removeModel(e.cacheManagerName);
  },

  handleCacheDetails: function(e) {
    var cacheManagerName = e.cacheManagerName;
      cacheManagerAttrs = this.agentPage.cacheManagers[cacheManagerName],
      elementCount = 0,
      offHeapSizeInBytes = 0,
      maxBytesLocalOffHeapSum = 0;

    $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttrs) {
      elementCount += cacheAttrs.Size;
      offHeapSizeInBytes += cacheAttrs.LocalOffHeapSizeInBytes;
      maxBytesLocalOffHeapSum += cacheAttrs.MaxBytesLocalOffHeap;

      var maxBytesLocalOffHeap = cacheAttrs.MaxBytesLocalOffHeap > 0 ? cacheAttrs.MaxBytesLocalOffHeap : cacheManagerAttrs.MaxBytesLocalOffHeap;
      cacheAttrs.offHeapUsage = maxBytesLocalOffHeap > 0 ? cacheAttrs.LocalOffHeapSizeInBytes/maxBytesLocalOffHeap : 0;
    });

    var divisor = cacheManagerAttrs.MaxBytesLocalOffHeap > 0 ? cacheManagerAttrs.MaxBytesLocalOffHeap : maxBytesLocalOffHeapSum;
    var offHeapUsage = divisor > 0 ? offHeapSizeInBytes/divisor : 0;

    this.updateCacheManagerModel(cacheManagerName, {
      name: cacheManagerName,
      status: cacheManagerAttrs.Status.split("_")[1],
      hitRate: cacheManagerAttrs.CacheHitRate,
      elementCount: elementCount,
      offHeapUsage: offHeapUsage
    });

    if (this.expandedCacheManagers[cacheManagerName]) {
      this.updateExposedCaches(cacheManagerName);
    }
  },

  findCacheManagerNode: function(cacheManagerName) {
    var result = null;
    var kTopologyTree = this.$topologyContent.data("kendoTTreeView");
    var $group = this.$topologyContent.children(".k-group");

    $group.children(".k-item").each(function() {
      var $el = $(this);
      var name = $el.find("input:first").attr("name");
      if (name == cacheManagerName) {
        result = $el;
        return false;
      }
    });

    return result;
  },

  removeCacheManagerNode: function(cacheManagerName) {
    var $node = this.findCacheManagerNode(cacheManagerName);

    if ($node) {
      this.$topologyContent.data("kendoTTreeView").remove($node);
    }
  },

  removeCacheNode: function(cacheName, cacheManagerName) {
    var kTopologyTree = this.$topologyContent.data("kendoTTreeView");
    var $node = this.findCacheManagerNode(cacheManagerName);

    if ($node) {
      var $group = $node.children(".k-group");

      $group.children(".k-item").each(function() {
        var $el = $(this);
        var name = $el.find("input:first").attr("name");
        if (name == cacheName) {
          kTopologyTree.remove($el);
          return;
        }
      });
    }
  },

  updateCacheManagerModel: function(cacheManagerName, entry) {
    this.$healthMetricsGrid.data("kendoTGrid").updateModel(cacheManagerName, entry);
  },

  handleResponseComplete: function(e) {
    if ($.isEmptyObject(this.expandedCacheManagers)) {
      this.healthMetricsGridDS.fetch();
    }
  },
  
  refresh: function() {},

  updateExposedCaches: function(cacheManagerName) {
    var that = this,
      cacheManagerAttrs = this.agentPage.cacheManagers[cacheManagerName],
      $grid = this.expandedCacheManagers[cacheManagerName];

    if ($grid) {
      var kGrid = $grid.data("kendoTGrid"),
        ds = kGrid.dataSource;

      if (ds.total() == 0) {
        var data = [];
        $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttrs) {
          data.push({
            cacheName: cacheName,
            hitRate: cacheAttrs.CacheHitRate,
            elementCount: cacheAttrs.Size,
            offHeapUsage: cacheAttrs.offHeapUsage,
            terracottaClustered: cacheAttrs.TerracottaClustered
          });
        });
        ds.data(data);
      } else {
        $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttrs) {
          kGrid.updateModel(cacheName, {
            cacheName: cacheName,
            hitRate: cacheAttrs.CacheHitRate,
            elementCount: cacheAttrs.Size,
            offHeapUsage: cacheAttrs.offHeapUsage,
            terracottaClustered: cacheAttrs.TerracottaClustered
          });
        });
        kGrid.dataSource.fetch();
      }
    }
  },

  exposeCaches: function(cacheManagerName, target) {
    var that = this;
    var cacheManagerAttrs = this.agentPage.cacheManagers[cacheManagerName];
    var caches = cacheManagerAttrs.caches;
    var cacheData = [];

    if (caches != null) {
      $.each(caches, function(cacheName, cacheAttrs) {
        cacheData.push({
          cacheName: cacheName,
          hitRate: cacheAttrs.CacheHitRate,
          elementCount: cacheAttrs.Size,
          offHeapUsage: cacheAttrs.offHeapUsage,
          terracottaClustered: cacheAttrs.TerracottaClustered
        });
      });
    }
    if(cacheData.length > 0) {
      var ds = new kendo.data.DataSource({
        data: cacheData,
        schema: {
          model: {
            id: "cacheName",
            fields: {
              cacheName:    {type: "string", editable: false},
              hitRate:      {type: "number", editable: false},
              elementCount: {type: "number", editable: false},
              offHeapUsage: {type: "number", editable: false}
            }
          }
        },
        sort: {field: "cacheName", dir: "asc"},
        pageSize: 5
      });
      $grid = $("<div/>").appendTo(target).kendoTGrid({
        dataSource: ds,
        scrollable: true,
        sortable: true,
        pageable: true,
        resizable: true,
        selectable: "row",
        columns: [
          {
            title: "Cache",
            field: "cacheName",
            template: "# if (terracottaClustered) { # <span title='Terracotta-clustered' class='clusteredCache'> # } else { # <span class='nonClusteredCache'> # } # #= cacheName # </span>",
            width: "40%"
          },
          {
            title: "Hit Rate (hits/s)",
            field: "hitRate",
            template: '#= formatIntRightJustified(hitRate) #',
            width: "20%"
          },
          {
            title: "Element Count",
            field: "elementCount",
            template: '#= formatIntRightJustified(elementCount) #',
            width: "20%"
          },
          {
            title: "OffHeap Usage",
            field: "offHeapUsage",
            template: '#= formatPercentageRightJustified(offHeapUsage) #',
            width: "20%"
          }
        ]
      });
      this.expandedCacheManagers[cacheManagerName] = $grid;
    }
    else {
      $grid = $("<span>").appendTo(target).html("&nbsp;&nbsp; - - This CacheManager has no Caches.");
    }
  },

  removeExposedCache: function(cacheManagerName, cacheName) {
    var that = this,
      $detailGrid = this.expandedCacheManagers[cacheManagerName];

    if ($detailGrid) {
      $detailGrid.data("kendoTGrid").removeModel(cacheName);
    }
  }
});