/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.servlet;

import com.terracotta.license.LicenseManager;
import com.terracotta.management.security.SecurityContextManager;
import com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener;
import com.terracotta.management.services.ConfigService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.terracotta.license.LicenseException;
import org.terracotta.management.ServiceLocator;

public final class SetupAwareFilter
implements Filter {
    private static final String TMC_HOME = "/index.jsp";
    private static final String TMC_AUTHENTICATION = "/setup/authenticationSetup.jsp";
    private static final String TMC_RESTART = "/setup/restart.jsp";
    private static final String TMC_LOGOUT_URL = "/logout.jsp";
    private final SecurityContextManager securityCtxtMgr = (SecurityContextManager)ServiceLocator.locate(SecurityContextManager.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        if (TMSEnvironmentLoaderListener.HAS_LICENSE == null) {
            try {
                LicenseManager.verifyTMCCapability();
                TMSEnvironmentLoaderListener.HAS_LICENSE = true;
                TMSEnvironmentLoaderListener.LICENSE_IS_COMMERCIAL_LICENSE = LicenseManager.isCommercialLicense();
            }
            catch (LicenseException e) {
                TMSEnvironmentLoaderListener.HAS_LICENSE = false;
            }
        }
        Boolean authenticationEnabled = ((ConfigService)ServiceLocator.locate(ConfigService.class)).isAuthenticationEnabled();
        if (TMSEnvironmentLoaderListener.HAS_LICENSE.booleanValue() && authenticationEnabled == null) {
            if (req.getRequestURI().equals(req.getContextPath() + "/login.jsp") || req.getRequestURI().equals(req.getContextPath() + "/setup/accountSetup.jsp") || req.getRequestURI().equals(req.getContextPath() + TMC_LOGOUT_URL) || req.getRequestURI().equals(req.getContextPath() + TMC_HOME)) {
                RequestDispatcher rd = req.getSession().getServletContext().getRequestDispatcher(TMC_AUTHENTICATION);
                rd.forward((ServletRequest)req, (ServletResponse)resp);
            } else {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        } else if (TMSEnvironmentLoaderListener.HAS_LICENSE.booleanValue() && authenticationEnabled != null && authenticationEnabled.booleanValue()) {
            if (this.tmcNeedsToRestart(authenticationEnabled)) {
                this.redirectToRestartPage(filterChain, req, resp);
                return;
            }
            boolean ctxtValid = this.securityCtxtMgr.hasValidSecurityContext();
            if (!ctxtValid && req.getRequestURI().startsWith(req.getContextPath() + "/login.jsp") || req.getRequestURI().equals(req.getContextPath() + TMC_AUTHENTICATION)) {
                RequestDispatcher rd = req.getSession().getServletContext().getRequestDispatcher("/setup/accountSetup.jsp");
                rd.forward((ServletRequest)req, (ServletResponse)resp);
            } else if (ctxtValid && req.getRequestURI().startsWith(req.getContextPath() + "/setup")) {
                resp.sendRedirect(req.getContextPath() + "/login.jsp");
            } else {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        } else if (TMSEnvironmentLoaderListener.HAS_LICENSE.booleanValue() && !authenticationEnabled.booleanValue() && this.tmcNeedsToRestart(authenticationEnabled)) {
            this.redirectToRestartPage(filterChain, req, resp);
        } else if (req.getRequestURI().equals(req.getContextPath() + "/login.jsp") || req.getRequestURI().equals(req.getContextPath() + "/setup/accountSetup.jsp") || req.getRequestURI().equals(req.getContextPath() + TMC_LOGOUT_URL) || req.getRequestURI().equals(req.getContextPath() + TMC_AUTHENTICATION)) {
            resp.sendRedirect(req.getContextPath() + TMC_HOME);
        } else {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private void redirectToRestartPage(FilterChain filterChain, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getRequestURI().startsWith(req.getContextPath() + "/login.jsp") || req.getRequestURI().startsWith(req.getContextPath() + "/setup/accountSetup.jsp") || req.getRequestURI().equals(req.getContextPath() + TMC_AUTHENTICATION) || req.getRequestURI().equals(req.getContextPath() + TMC_HOME) || req.getRequestURI().equals(req.getContextPath() + TMC_LOGOUT_URL)) {
            RequestDispatcher rd = req.getSession().getServletContext().getRequestDispatcher(TMC_RESTART);
            rd.forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    public void destroy() {
    }

    private boolean tmcNeedsToRestart(Boolean authenticationEnabled) {
        SecurityContextManager securityContextManager = (SecurityContextManager)ServiceLocator.locate(SecurityContextManager.class);
        return authenticationEnabled != false && securityContextManager == null || securityContextManager != null && authenticationEnabled == false;
    }
}

