/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.services.impl;

import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.terracotta.management.AggregateCallback;
import com.terracotta.management.AggregateCollectionCallback;
import com.terracotta.management.config.Agent;
import com.terracotta.management.jaxrs.AggregateObjectMapperProvider;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener;
import com.terracotta.management.services.ConfigService;
import com.terracotta.management.services.JerseyClientFactory;
import com.terracotta.management.services.ResourceServiceClientService;
import com.terracotta.management.services.impl.AgentNotAvailableException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.sf.ehcache.management.resource.CacheEntity;
import net.sf.ehcache.management.resource.CacheManagerEntity;
import net.sf.ehcache.management.resource.CacheStatisticSampleEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.resource.AgentEntity;
import org.terracotta.management.resource.AgentMetadataEntity;
import org.terracotta.management.resource.Representable;
import org.terracotta.management.resource.VersionedEntity;

/*
 * Exception performing whole class analysis ignored.
 */
public final class JerseyResourceServiceClientService
implements ResourceServiceClientService,
Observer {
    private static final String HTTPS_SCHEME = "https://";
    private static final String URI_CTXT_SEP = "/";
    private static final Logger LOG = LoggerFactory.getLogger(JerseyResourceServiceClientService.class);
    private final ConfigService configSvc;
    private final JerseyClientFactory clientFactory;
    private final Authorizer authorizer;
    private final ConcurrentHashMap<String, Client> clientsById;

    public JerseyResourceServiceClientService(ConfigService configSvc, JerseyClientFactory clientFactory, Authorizer authorizer) {
        this.configSvc = configSvc;
        this.configSvc.registerObserver((Observer)this);
        this.clientFactory = clientFactory;
        this.authorizer = authorizer;
        Collection knownAgents = configSvc.getAgents();
        ConcurrentHashMap<String, Client> clientsById = new ConcurrentHashMap<String, Client>(knownAgents.size());
        for (Agent a : knownAgents) {
            clientsById.put(a.getId(), this.prepareClient(a));
        }
        this.clientsById = clientsById;
    }

    public Set<String> getKnownAgentIds() {
        return Collections.unmodifiableSet(this.clientsById.keySet());
    }

    public <RESOURCE extends VersionedEntity> void proxyGet(AggregateCallback<RESOURCE> callback, URI request, String[] agentIds, Class<RESOURCE> entityClass) {
        HashMap<String, Future> futures = new HashMap<String, Future>(this.clientsById.size());
        Collection<String> ids = agentIds == null ? this.clientsById.keySet() : Arrays.asList(agentIds);
        for (String string : ids) {
            Future asyncCalc;
            Client client = (Client)this.clientsById.get(string);
            if (client == null) continue;
            URI location = JerseyResourceServiceClientService.buildURI((Client)client, (URI)request);
            AsyncWebResource resource = client.asyncResource(location);
            try {
                asyncCalc = resource.header("tc-identity-token", (Object)this.authorizer.getSessionId()).get(entityClass);
            }
            catch (UniformInterfaceException e) {
                LOG.warn("Failure setting up async computation.", (Throwable)e);
                continue;
            }
            futures.put(string, asyncCalc);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                VersionedEntity entity = (VersionedEntity)((Future)entry.getValue()).get();
                entity.setAgentId((String)entry.getKey());
                callback.addResponse(entity);
            }
            catch (InterruptedException e) {
                LOG.warn("Future interrupted.", (Throwable)e);
            }
            catch (ExecutionException e) {
                this.logAgentExecutionException(e);
            }
        }
    }

    public <RESOURCE extends Representable> void proxyGet(AggregateCollectionCallback<RESOURCE> callback, URI request, String[] agentIds, Class<RESOURCE> entityClass) {
        HashMap<String, Future> futures = new HashMap<String, Future>(this.clientsById.size());
        Collection<String> ids = agentIds == null ? this.clientsById.keySet() : Arrays.asList(agentIds);
        for (String string : ids) {
            Future asyncCalc;
            Client client = (Client)this.clientsById.get(string);
            if (client == null) continue;
            URI location = JerseyResourceServiceClientService.buildURI((Client)client, (URI)request);
            AsyncWebResource resource = client.asyncResource(location);
            try {
                asyncCalc = resource.header("tc-identity-token", (Object)this.authorizer.getSessionId()).get(JerseyResourceServiceClientService.buildGenericType(entityClass));
            }
            catch (UniformInterfaceException e) {
                LOG.warn("Failure setting up async computation.", (Throwable)e);
                continue;
            }
            futures.put(string, asyncCalc);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                Collection entities = (Collection)((Future)entry.getValue()).get();
                for (Representable entity : entities) {
                    entity.setAgentId((String)entry.getKey());
                }
                callback.addResponses(entities);
            }
            catch (InterruptedException e) {
                LOG.warn("Future interrupted.", (Throwable)e);
            }
            catch (ExecutionException e) {
                this.logAgentExecutionException(e);
            }
        }
    }

    public void proxyDelete(URI request, String agentId) {
        Client client = (Client)this.clientsById.get(agentId);
        if (client == null) {
            throw new WebApplicationException(Response.Status.GONE);
        }
        WebResource resource = client.resource(JerseyResourceServiceClientService.buildURI((Client)client, (URI)request));
        resource.header("tc-identity-token", (Object)this.authorizer.getSessionId()).delete();
    }

    public <RESOURCE> void proxyPut(URI request, RESOURCE entity, String agentId) {
        Client client = (Client)this.clientsById.get(agentId);
        if (client == null) {
            throw new WebApplicationException(Response.Status.GONE);
        }
        WebResource resource = client.resource(JerseyResourceServiceClientService.buildURI((Client)client, (URI)request));
        ((WebResource.Builder)resource.type(MediaType.APPLICATION_JSON_TYPE).header("tc-identity-token", (Object)this.authorizer.getSessionId())).put(entity);
    }

    public <RESOURCE> Response proxyPost(URI request, RESOURCE entity, String agentId) {
        Client client = (Client)this.clientsById.get(agentId);
        if (client != null) {
            URI location = JerseyResourceServiceClientService.buildURI((Client)client, (URI)request);
            WebResource resource = client.resource(location);
            resource.header("tc-identity-token", (Object)this.authorizer.getSessionId()).post(entity);
            return Response.created((URI)location).build();
        }
        throw new WebApplicationException(Response.Status.GONE);
    }

    @Override
    public void update(Observable o, Object id) {
        String agentId = (String)String.class.cast(id);
        Agent agent = this.configSvc.getAgent(agentId);
        if (agent == null) {
            this.clientsById.remove(agentId);
        } else {
            URI checkClientURI;
            Client current = (Client)this.clientsById.get(agentId);
            if (TMSEnvironmentLoaderListener.HAS_LICENSE.booleanValue()) {
                agent.setSecured(Boolean.valueOf(true));
            }
            Client newClient = this.prepareClient(agent);
            try {
                checkClientURI = new URI("agents/info");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("BUG Alert! Invalid agent info URI.", e);
            }
            URI checkLocation = JerseyResourceServiceClientService.buildURI((Client)newClient, (URI)checkClientURI);
            WebResource resource = newClient.resource(checkLocation);
            boolean available = true;
            try {
                AgentMetadataEntity ame;
                Collection ames = (Collection)resource.header("tc-identity-token", (Object)this.authorizer.getSessionId()).get(JerseyResourceServiceClientService.buildGenericType(AgentMetadataEntity.class));
                if (!ames.isEmpty() && agent.update(ame = (AgentMetadataEntity)ames.iterator().next())) {
                    newClient = this.prepareClient(agent);
                }
            }
            catch (RuntimeException e) {
                available = false;
            }
            if (current != null) {
                this.clientsById.replace(agentId, current, newClient);
            } else {
                this.clientsById.putIfAbsent(agentId, newClient);
            }
            if (!available) {
                throw new AgentNotAvailableException("REST service not currently available or there is a problem with the configuration.");
            }
        }
    }

    private void logAgentExecutionException(ExecutionException e) {
        if (LOG.isDebugEnabled()) {
            LOG.warn("Failed to execute request against monitorable entity.", (Throwable)e);
        } else {
            LOG.warn("Failed to execute request against monitorable entity. {}", (Object)e.getMessage());
        }
    }

    private static URI buildURI(Client client, URI request) {
        URI baseUri = (URI)client.getProperties().get("CLIENT_BASE_URI");
        if (baseUri == null) {
            throw new RuntimeException("Bug Alert! Invalid aggregator configuration: missing client base URI.");
        }
        return baseUri.resolve(request);
    }

    private Client prepareClient(Agent a) {
        URI clientBase;
        Integer rto;
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        clientConfig.getClasses().add(AggregateObjectMapperProvider.class);
        Integer cto = a.getConnectionTimeoutMillis();
        if (cto != null) {
            clientConfig.getProperties().put("com.sun.jersey.client.property.connectTimeout", cto);
        }
        if ((rto = a.getReadTimeoutMillis()) != null) {
            clientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", rto);
        }
        try {
            clientBase = JerseyResourceServiceClientService.extractBaseURI((Agent)a);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("BUG Alert! Failed to extract valid URI from agent while setting up client. ");
        }
        clientConfig.getProperties().put("CLIENT_BASE_URI", clientBase);
        clientConfig.getProperties().put("CLIENT_CERT_AUTH_ENABLED", clientBase.toString().startsWith("https://") ? a.isClientAuthEnabled() : false);
        clientConfig.getProperties().put("SECURITY_ENABLED", a.isSecured());
        return this.clientFactory.createClient((ClientConfig)clientConfig);
    }

    private static URI extractBaseURI(Agent agent) throws URISyntaxException {
        URL agentURL;
        try {
            agentURL = new URL(agent.getAgentLocation());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("BUG Alert! Failed to retrieve agent location URL while setting up client.");
        }
        String path = agentURL.getPath();
        if (!path.matches(".*/tc-management-api/$")) {
            path = path + "/tc-management-api/";
        } else if (!path.endsWith("/")) {
            path = path + "/";
        }
        return new URI(agentURL.getProtocol() + "://" + agentURL.getAuthority() + path);
    }

    private static GenericType buildGenericType(Class<? extends Representable> clazz) {
        if (clazz == AgentEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == AgentMetadataEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == CacheManagerEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == CacheEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        if (clazz == CacheStatisticSampleEntity.class) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        throw new UnsupportedOperationException(String.format("Unknown entity class \"%s\" for GenericType construction.", clazz.getCanonicalName()));
    }
}

