/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.web.jersey;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.keychain.URIKeyName;
import com.terracotta.management.security.HMACBuilder;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.RequestTicketMonitor;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;

public final class TMSRequestSecurityClientFilter
extends ClientFilter {
    private final RequestTicketMonitor monitor;
    private final KeyChainAccessor accessor;

    public TMSRequestSecurityClientFilter(RequestTicketMonitor monitor, KeyChainAccessor accessor) {
        this.monitor = monitor;
        this.accessor = accessor;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        boolean securityEnabled = (Boolean)cr.getProperties().get("SECURITY_ENABLED");
        if (securityEnabled) {
            boolean useClientCertAuth = (Boolean)cr.getProperties().get("CLIENT_CERT_AUTH_ENABLED");
            MultivaluedMap headers = cr.getHeaders();
            String ticket = this.monitor.issueRequestTicket();
            headers.putSingle((Object)"req-ticket", (Object)ticket);
            if (ticket == null) {
                throw new ClientHandlerException("Failed to obtain request ticket for security.");
            }
            if (!useClientCertAuth) {
                String sessId = (String)((List)headers.get((Object)"tc-identity-token")).get(0);
                URIKeyName alias = new URIKeyName((URI)cr.getProperties().get("CLIENT_BASE_URI"));
                headers.putSingle((Object)"alias", (Object)alias);
                try {
                    headers.putSingle((Object)"signature", (Object)HMACBuilder.getInstance((byte[])this.accessor.retrieveSecret((KeyName)alias)).addMessageComponent(ticket).addMessageComponent(sessId).addMessageComponent(alias.getURI().toString()).buildEncoded());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("BUG Alert! Failed to create signed hash.", e);
                }
                catch (InvalidKeyException e) {
                    throw new RuntimeException("BUG Alert! Failed to create signed hash.", e);
                }
            }
        } else {
            cr.getHeaders().remove((Object)"tc-identity-token");
        }
        return this.getNext().handle(cr);
    }
}

