/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.realm;

import com.terracotta.management.security.shiro.ShiroIniFileConstants;
import java.io.File;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.config.Ini;
import org.apache.shiro.realm.text.IniRealm;

public final class TCIniRealm
extends IniRealm {
    public TCIniRealm() {
        this(new File(System.getProperty("com.tc.management.security.ini") == null ? ShiroIniFileConstants.DFLT_INI_FILE_LOCATION : System.getProperty("com.tc.management.security.ini")));
    }

    public TCIniRealm(File iniFile) {
        Ini ini;
        if (iniFile.exists()) {
            String iniFilePath = iniFile.getAbsolutePath();
            Ini ini2 = Ini.fromResourcePath((String)iniFilePath);
            this.setIni(ini2);
            this.setResourcePath(iniFilePath);
        }
        if ((ini = this.getIni()) == null || ini.isEmpty()) {
            SimpleAccount dummy = new SimpleAccount((Object)"__tc-dummy", (Object)"$shiro1$SHA-256$100000$f3WQKo0JpXZp7LWCy+kP4Q==$STWFWj5IYGDMwgpPk8sWoudXPPwqRol/JEI0ZqQm+Js=", this.getName(), null, null);
            dummy.setLocked(true);
            this.users.put(dummy.getPrincipals().getPrimaryPrincipal().toString(), dummy);
        }
    }

    public boolean removeAccount(String username) {
        return this.users.remove(username) != null;
    }

    public SimpleAccount getAccount(String username) {
        return (SimpleAccount)this.users.get(username);
    }

    public boolean isEmpty() {
        return this.users.isEmpty() || this.users.size() == 1 && this.users.get("__tc-dummy") != null;
    }
}

