/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro;

import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.security.SecurityContextManager;
import com.terracotta.management.security.shiro.realm.TCIniRealm;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserRole;
import com.terracotta.management.user.dao.DatastoreNotFoundException;
import com.terracotta.management.user.dao.impl.IniFileUserInfoDao;
import com.terracotta.management.user.impl.DfltUserInfo;
import com.terracotta.management.user.services.UserService;
import java.util.Collection;
import org.apache.shiro.authc.SimpleAccount;
import org.terracotta.management.ServiceExecutionException;

public final class ShiroSecurityContextManager
implements SecurityContextManager,
UserService {
    private final IniFileUserInfoDao iniUserInfoDao;
    private final TCIniRealm tcIniRealm;

    public ShiroSecurityContextManager(IniFileUserInfoDao iniUserInfoDao, TCIniRealm tcIniRealm) {
        this.iniUserInfoDao = iniUserInfoDao;
        this.tcIniRealm = tcIniRealm;
    }

    public synchronized void addUser(UserInfo user) throws ServiceExecutionException {
        try {
            this.iniUserInfoDao.create(user);
        }
        catch (DataAccessException e) {
            throw new ServiceExecutionException(String.format("Unable to create '%s'. Check the configured location of the security ini file and the file permissions for the user that started the application.", user));
        }
        this.tcIniRealm.addAccount(user.getUsername(), user.getPasswordHash(), user.getRoles() == null ? null : UserRole.convertRoles((Collection)user.getRoles()).toArray(new String[0]));
    }

    public synchronized void updateUser(UserInfo user) throws ServiceExecutionException {
        try {
            this.iniUserInfoDao.createOrUpdate(user);
        }
        catch (DataAccessException e) {
            throw new ServiceExecutionException(String.format("Unable to update '%s'. Check the configured location of the security ini file and the file permissions for the user that started the application.", user));
        }
        SimpleAccount acct = this.tcIniRealm.getAccount(user.getUsername());
        acct.setCredentials((Object)user.getPasswordHash());
        acct.setRoles(UserRole.convertRoles((Collection)user.getRoles()));
    }

    public synchronized void disableUser(String username) {
        SimpleAccount acct = this.tcIniRealm.getAccount(username);
        if (acct != null) {
            acct.setLocked(true);
        }
    }

    public synchronized void deleteUser(UserInfo user) throws ServiceExecutionException {
        try {
            this.iniUserInfoDao.delete(user);
        }
        catch (DataAccessException e) {
            throw new ServiceExecutionException(String.format("Unable to delete '%s'. Check the configured location of the security ini file and the file permissions for the user that started the application.", user));
        }
        this.tcIniRealm.removeAccount(user.getUsername());
    }

    public synchronized UserInfo getUser(String username) {
        SimpleAccount acct = this.tcIniRealm.getAccount(username);
        return acct == null ? null : new DfltUserInfo(username, acct.getCredentials().toString(), UserRole.convertRoleNames((Collection)acct.getRoles()));
    }

    public synchronized boolean hasValidSecurityContext() {
        boolean valid = true;
        if (this.tcIniRealm.isEmpty()) {
            valid = false;
        }
        if (valid) {
            try {
                this.iniUserInfoDao.validate(false);
                valid = this.iniUserInfoDao.hasUserInfos();
            }
            catch (DatastoreNotFoundException e) {
                valid = false;
            }
            catch (DataAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return valid;
    }
}

