/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.services.impl;

import com.terracotta.management.security.services.SecurityContextSetupService;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserInfoFactory;
import com.terracotta.management.user.UserRole;
import com.terracotta.management.user.services.UserService;
import org.terracotta.management.ServiceExecutionException;

public final class IniFileSetupService
implements SecurityContextSetupService {
    private static final String ADMIN_USERNAME = "admin";
    private static final String OPERATOR_USERNAME = "operator";
    public final UserService userSvc;
    public final UserInfoFactory userInfoFactory;

    public IniFileSetupService(UserService userSvc, UserInfoFactory userInfoFactory) {
        this.userSvc = userSvc;
        this.userInfoFactory = userInfoFactory;
    }

    public synchronized void seedSecurityContext(String adminPassword, String operatorPassword) throws ServiceExecutionException {
        UserInfo admin = this.userInfoFactory.createUser(ADMIN_USERNAME, adminPassword, new UserRole[]{UserRole.ADMIN, UserRole.OPERATOR});
        UserInfo operator = this.userInfoFactory.createUser(OPERATOR_USERNAME, operatorPassword, new UserRole[]{UserRole.OPERATOR});
        this.userSvc.addUser(admin);
        this.userSvc.addUser(operator);
    }
}

