/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security.impl;

import com.terracotta.management.security.Authorizer;
import com.terracotta.management.user.UserRole;

import java.util.Set;

/**
 * @author brandony
 */
public final class NoSecurityContextAuthorizer implements Authorizer {

  @Override
  public boolean isUserInRole(UserRole role) {
    return true;
  }

  @Override
  public boolean isUserInAllRoles(Set<UserRole> roles) {
    return true;
  }

  @Override
  public boolean isUserInAnyRole(Set<UserRole> roles) {
    return true;
  }

  @Override
  public String getPrincipal() {
    return "tc_no_security_ctxt";
  }

  @Override
  public String getPrincipalBySessionId(String sessionId,
                                        boolean isAuthenticated) {
    return null;
  }

  @Override
  public String getSessionId() {
    return null;
  }
}