/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import com.terracotta.management.AggregateCollectionCallback;
import net.sf.ehcache.management.resource.CacheStatisticSampleEntity;
import net.sf.ehcache.management.resource.services.CacheStatisticSamplesResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import java.util.Collection;


/**
 * @author brandony
 */
@Path("/agents/cacheManagers/caches/statistics/samples")
public final class AggregateStatisticSamplesResourceService
    extends AggregateResourceServiceSupport<CacheStatisticSampleEntity>
    implements CacheStatisticSamplesResourceService {
  private static final Logger LOG = LoggerFactory.getLogger(AggregateStatisticSamplesResourceService.class);

  public AggregateStatisticSamplesResourceService() {
    super();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Collection<CacheStatisticSampleEntity> getCacheStatisticSamples(UriInfo info) {
    LOG.info(String.format("Invoking AggregateStatisticSamplesResourceService.getCacheStatisticSamples: %s",
        info.getRequestUri()));

    getValidator().validateSafe(info);
    AggregateCollectionCallback<CacheStatisticSampleEntity> callback = new AggregateCollectionCallback<CacheStatisticSampleEntity>() {
    };

    return doGet(info, callback, CacheStatisticSampleEntity.class);
  }
}
