/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.jaxrs;

import net.sf.ehcache.management.resource.CacheManagerEntity;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.module.SimpleModule;
import org.terracotta.management.resource.Representable;

import javax.ws.rs.ext.ContextResolver;
import java.io.IOException;

/**
 * @author brandony
 */
// TODO: Generalize the serialization/deserialization strategy for other Representables moving forward.
public final class AggregateObjectMapperProvider implements ContextResolver<ObjectMapper> {
  private static final String ROOT_MUTATOR_METHOD_NAME = "setRootRepresentables";

  private static final String EHCACHE_ROOT_NAME = "cacheManagers";

  private final ObjectMapper om;

  public AggregateObjectMapperProvider() {
    SimpleModule module = new SimpleModule("AggregateModule", new Version(1, 0, 0, null));
    module.addDeserializer(Representable.class, new JsonDeserializer<Representable>() {

      @Override
      public Representable deserialize(JsonParser jp,
                                       DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return om.readValue(jp, CacheManagerEntity.class);
      }
    });
    ObjectMapper objectMapper = new ObjectMapper();
    objectMapper.registerModule(module);

    DeserializationConfig dfltDS = objectMapper.getDeserializationConfig();
    objectMapper.setDeserializationConfig(dfltDS.withPropertyNamingStrategy(new PropertyNamingStrategy() {

      /**
       * @see org.codehaus.jackson.map.PropertyNamingStrategy#nameForSetterMethod(org.codehaus.jackson.map.MapperConfig,
       *      org.codehaus.jackson.map.introspect.AnnotatedMethod, java.lang.String)
       */
      @Override
      public String nameForSetterMethod(MapperConfig<?> config,
                                        AnnotatedMethod method,
                                        String defaultName) {
        if (ROOT_MUTATOR_METHOD_NAME.equals(method.getName())) return EHCACHE_ROOT_NAME;
        else return super.nameForSetterMethod(config, method, defaultName);
      }
    }));

    this.om = objectMapper;
  }

  @Override
  public ObjectMapper getContext(Class<?> arg0) {
    return om;
  }

}
