/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.config.jaxb.adapters;

import com.terracotta.management.config.Agent;

import javax.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author Ludovic Orban
 */
public final class AdaptedAgentsMap {

  private final List<AdaptedGroup> groups = new ArrayList<AdaptedGroup>();

  @XmlElement(name = "group")
  public List<AdaptedGroup> getGroups() {
    return groups;
  }

  public void addGroup(String groupId, Collection<Agent> agents) {
    groups.add(new AdaptedGroup(groupId, agents));
  }

}
