package com.terracotta.management.config;

import org.terracotta.management.resource.AgentMetadataEntity;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * <p>
 * A class representing connection detail of a monitorable entity.
 * </p>
 *
 * @author Ludovic Orban
 * @author brandony
 */
@XmlRootElement
public final class Agent {

  private String name;

  private String groupId;

  private String agentLocation;

  private Integer connectionTimeoutMillis;

  private Integer readTimeoutMillis;

  private Boolean secured;

  private Boolean clientAuthEnabled;

  private Integer sampleHistorySize = 30;

  private Integer sampleIntervalSeconds = 1;
  
  private Boolean enabled = true;

  public Agent(){}

  public Agent(Agent source) {
    this.name = source.getName();
    this.groupId = source.getGroupId();
    this.agentLocation = source.getAgentLocation();
    this.connectionTimeoutMillis = source.getConnectionTimeoutMillis();
    this.readTimeoutMillis = source.getReadTimeoutMillis();
    this.secured = source.isSecured();
    this.clientAuthEnabled = source.isClientAuthEnabled();
    this.sampleHistorySize = source.getSampleHistorySize();
    this.sampleIntervalSeconds = source.getSampleIntervalSeconds();
    this.enabled = source.isEnabled();
  }

  //@JsonIgnore
  //@XmlTransient
  public String getId() {
    if (groupId == null && name == null) {
      return null;
    }
    return groupId + "_" + name;
  }

  public static String groupOfId(String id) {
    if (id == null) {
      return null;
    }
    return id.split("_")[0];
  }

  public static String nameOfId(String id) {
    if (id == null) {
      return null;
    }
    return id.split("_")[1];
  }

  @XmlAttribute
  public String getName() {
    return name;
  }

  @XmlAttribute
  public String getGroupId() {
    return groupId;
  }

  @XmlAttribute
  public String getAgentLocation() {
    return agentLocation;
  }

  @XmlAttribute
  public Integer getConnectionTimeoutMillis() {
    return connectionTimeoutMillis;
  }

  @XmlAttribute
  public Integer getReadTimeoutMillis() {
    return readTimeoutMillis;
  }

  @XmlAttribute
  public Boolean isClientAuthEnabled() {
    return clientAuthEnabled == null ? Boolean.FALSE : clientAuthEnabled;
  }

  @XmlAttribute
  public Boolean isSecured() {
    return secured == null ? Boolean.FALSE : secured;
  }

  @XmlAttribute
  public Integer getSampleHistorySize() {
    return sampleHistorySize;
  }

  @XmlAttribute
  public Integer getSampleIntervalSeconds() {
    return sampleIntervalSeconds;
  }
  
  @XmlAttribute
  public Boolean isEnabled() {
    return enabled == null ? Boolean.FALSE : enabled;
  }

  public void setName(String name) {
    this.name = name;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  public void setAgentLocation(String agentLocation) {
    this.agentLocation = agentLocation;
  }

  public void setConnectionTimeoutMillis(Integer connectionTimeoutMillis) {
    this.connectionTimeoutMillis = connectionTimeoutMillis;
  }

  public void setReadTimeoutMillis(Integer readTimeoutMillis) {
    this.readTimeoutMillis = readTimeoutMillis;
  }

  public void setSecured(Boolean secured) {
    this.secured = secured;
  }

  public void setClientAuthEnabled(Boolean clientAuthEnabled) {
    this.clientAuthEnabled = clientAuthEnabled;
  }

  public void setSampleHistorySize(Integer sampleHistorySize) {
    this.sampleHistorySize = sampleHistorySize;
  }

  public void setSampleIntervalSeconds(Integer sampleIntervalSeconds) {
    this.sampleIntervalSeconds = sampleIntervalSeconds;
  }

  public void setEnabled(boolean enabled) {
    this.enabled = enabled;
  }
  
  public boolean update(AgentMetadataEntity agentMetadataEntity) {
    boolean updated = false;

    if(agentMetadataEntity.isEnabled() != isEnabled()) {
      setEnabled(agentMetadataEntity.isEnabled());
      updated = true;
    }

    if(agentMetadataEntity.isSecured() != isSecured()) {
      setSecured(agentMetadataEntity.isSecured());
      updated = true;
    }

    if(agentMetadataEntity.isNeedClientAuth() != isClientAuthEnabled()) {
      setClientAuthEnabled(agentMetadataEntity.isNeedClientAuth());
      updated = true;
    }

    if(agentMetadataEntity.getSampleHistorySize() != getSampleHistorySize()) {
      setSampleHistorySize(agentMetadataEntity.getSampleHistorySize());
      updated = true;
    }

    if(agentMetadataEntity.getSampleIntervalSeconds() != getSampleIntervalSeconds()) {
      setSampleIntervalSeconds(agentMetadataEntity.getSampleIntervalSeconds());
      updated = true;
    }

    return updated;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Agent agent = (Agent) o;

    String id = getId();
    if (id != null ? !id.equals(agent.getId()) : agent.getId() != null) return false;

    return true;
  }

  @Override
  public int hashCode() {
    String id = getId();
    return id != null ? id.hashCode() : 0;
  }

  @Override
  public String toString() {
    return "Agent{" +
        "name='" + name + '\'' +
        ", groupId='" + groupId + '\'' +
        ", agentLocation='" + agentLocation + '\'' +
        ", connectionTimeoutMillis=" + connectionTimeoutMillis +
        ", readTimeoutMillis=" + readTimeoutMillis +
        ", secured=" + secured +
        ", clientAuthEnabled=" + clientAuthEnabled +
        ", sampleHistorySize=" + sampleHistorySize +
        ", sampleIntervalSeconds=" + sampleIntervalSeconds +
        ", enabled=" + enabled +
        '}';
  }

}
