/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.servlet;

import com.terracotta.management.security.services.SecurityContextSetupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.resource.services.Utils;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * A {@code HttpRequestHandler} for account initialization.
 *
 * @author brandony
 */
public final class AccountInitializationServlet extends HttpServlet {
  public static final String ADMIN_PWD_ISSUE = "ADMIN_PWD_ISSUE";

  public static final String OPER_PWD_ISSUE = "OPER_PWD_ISSUE";

  public static final String TMC_SETUP_URL = "/setup/accountSetup.jsp";

  public static final String TMC_LOGIN_URL = "/login.jsp";

  private static final Logger LOG = LoggerFactory.getLogger(AccountInitializationServlet.class);

  private static final String ERR_MSG = "Passwords for %s setup do not match or are empty!";

  private static final String ADMIN_PWD = "adminPassword";

  private static final String ADMIN_CONF_PWD = "adminConfPassword";

  private static final String OPERATOR_PWD = "operatorPassword";

  private static final String OPERATOR_CONF_PWD = "operatorConfPassword";

  private final SecurityContextSetupService setupSvc;

  public AccountInitializationServlet() {
    setupSvc = ServiceLocator.locate(SecurityContextSetupService.class);
  }


  protected void doPost(HttpServletRequest req,
                      HttpServletResponse resp) throws ServletException, IOException {
    String adminCredential = req.getParameter(ADMIN_PWD);
    String adminConfCredential = req.getParameter(ADMIN_CONF_PWD);

    if (Utils.trimToNull(adminCredential) == null || Utils.trimToNull(adminConfCredential) == null || !adminCredential
        .equals(adminConfCredential)) {
      req.setAttribute(ADMIN_PWD_ISSUE, String.format(ERR_MSG, "admin"));
    } else {
      req.removeAttribute(ADMIN_PWD_ISSUE);
    }

    String operatorCredential = req.getParameter(OPERATOR_PWD);
    String operatorConfCredential = req.getParameter(OPERATOR_CONF_PWD);

    if (Utils.trimToNull(operatorCredential) == null || Utils
        .trimToNull(operatorConfCredential) == null || !operatorCredential.equals(operatorConfCredential)) {
      req.setAttribute(OPER_PWD_ISSUE, String.format(ERR_MSG, "operator"));
    } else {
      req.removeAttribute(OPER_PWD_ISSUE);
    }

    RequestDispatcher rd;
    if (req.getAttribute(ADMIN_PWD_ISSUE) == null && req.getAttribute(OPER_PWD_ISSUE) == null) {
      try {
        setupSvc.seedSecurityContext(adminCredential, operatorCredential);
      } catch (ServiceExecutionException e) {
        LOG.error("Failed to setup application!", e);
      }

      resp.sendRedirect(req.getContextPath() + TMC_LOGIN_URL);
    } else {
      rd = req.getSession().getServletContext().getRequestDispatcher(TMC_SETUP_URL);
      rd.forward(req, resp);
    }
  }
}
