/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security.web.impl;

import com.terracotta.management.security.RequestIdentityAsserter;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserInfoFactory;
import com.terracotta.management.user.UserRole;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author brandony
 */
public final class NoOpIdentityAsserter implements RequestIdentityAsserter {
  private static final String NO_OP_PRINCIPAL = "unlicensedAdmin";

  private final UserInfoFactory usrInfoFactory;

  public NoOpIdentityAsserter(UserInfoFactory usrInfoFactory) {
    this.usrInfoFactory = usrInfoFactory;
  }

  @Override
  public UserInfo assertIdentity(HttpServletRequest request,
                                 HttpServletResponse response) {
    return usrInfoFactory.createUser(NO_OP_PRINCIPAL, null, UserRole.ADMIN);
  }
}
