/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.security.services.impl;

import com.terracotta.management.security.services.SecurityContextSetupService;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserInfoFactory;
import com.terracotta.management.user.UserRole;
import com.terracotta.management.user.services.UserService;
import org.terracotta.management.ServiceExecutionException;

/**
 * @author brandony
 */
public final class IniFileSetupService implements SecurityContextSetupService {
  private static final String ADMIN_USERNAME = "admin";

  private static final String OPERATOR_USERNAME = "operator";

  public final UserService userSvc;

  public final UserInfoFactory userInfoFactory;

  public IniFileSetupService(UserService userSvc,
                             UserInfoFactory userInfoFactory) {
    this.userSvc = userSvc;
    this.userInfoFactory = userInfoFactory;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public synchronized void seedSecurityContext(String adminPassword,
                                               String operatorPassword) throws ServiceExecutionException {


    UserInfo admin = userInfoFactory.createUser(ADMIN_USERNAME, adminPassword, UserRole.ADMIN, UserRole.OPERATOR);
    UserInfo operator = userInfoFactory.createUser(OPERATOR_USERNAME, operatorPassword, UserRole.OPERATOR);

    userSvc.addUser(admin);
    userSvc.addUser(operator);
  }
}
