/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.security.services;

import org.terracotta.management.ServiceExecutionException;

/**
 * An interface for a service to establish a security context with 2 specific users:
 * <ul>
 *   <li>An administrator user, which is the super user account for the management application.</li>
 *   <li>A standard operator user whose role provides view only access.</li>
 * </ul>
 *
 * @author brandony
 */
public interface SecurityContextSetupService {
  /**
   * A service method to seed the security context with the administrator and operator accounts.
   *
   * @param adminCredential for the administrator account
   * @param operatorCredential for the operator account
   * @throws ServiceExecutionException
   */
  void seedSecurityContext(String adminCredential,
                           String operatorCredential) throws ServiceExecutionException;
}
