/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import org.terracotta.management.resource.services.Utils;

import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

/**
 * @author brandony
 */
public final class ResourceServiceUtils {

  public static final String AGENT_IDS_KEY = "ids";

  public static String[] buildAgentIds(UriInfo info) {
    String agentIds = info.getPathSegments().get(0).getMatrixParameters().getFirst(AGENT_IDS_KEY);
    return Utils.trimToNull(agentIds) == null ? null : agentIds.split(",");
  }

  public static UriBuilder cleanURI(UriInfo info) {
    String path = info.getPath();
    String agentIds = info.getPathSegments().get(0).getMatrixParameters().getFirst(AGENT_IDS_KEY);
    if (agentIds != null) path = path.replace(String.format(";%s=%s", AGENT_IDS_KEY, agentIds), "");
    return UriBuilder.fromPath(path);
  }
}
