/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import com.terracotta.management.AggregateCollectionCallback;
import org.terracotta.management.resource.AgentMetadataEntity;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/**
 * <p>
 * A callback strategy for returning {@link AgentMetadataEntity} objects for all known agents.
 * </p>
 *
 * @author brandony
 */
final class AgentMetadataEntityCollectionCallback extends AggregateCollectionCallback<AgentMetadataEntity> {

  private final Set<String> expectedAgentIds;

  AgentMetadataEntityCollectionCallback(Set<String> expectedAgentIds) {
    this.expectedAgentIds = expectedAgentIds;
  }

  /**
   * @see com.terracotta.management.AggregateCollectionCallback#calculateResult()
   */
  @Override
  public Collection<AgentMetadataEntity> calculateResult() {
    Collection<AgentMetadataEntity> result = new HashSet<AgentMetadataEntity>(expectedAgentIds.size());
    Set<String> unresponsiveAgents = new HashSet<String>(expectedAgentIds);

    for (Collection<AgentMetadataEntity> info : responses) {
      AgentMetadataEntity ame = info.iterator().next();
      unresponsiveAgents.remove(ame.getAgentId());
      result.addAll(info);
    }

    for (String id : unresponsiveAgents) {
      AgentMetadataEntity unresponsive = new AgentMetadataEntity();
      unresponsive.setAgentId(id);
      result.add(unresponsive);
    }

    return result;
  }
}
