/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.config.jaxb.adapters;

import com.terracotta.management.config.Agent;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import java.util.Collection;

/**
 * @author Ludovic Orban
 */
public final class AdaptedGroup {
  
  private String id;
  private Collection<Agent> agents;

  public AdaptedGroup() {
    this(null, null);
  }

  public AdaptedGroup(String id, Collection<Agent> agents) {
    this.id = id;
    this.agents = agents;
  }

  @XmlAttribute
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @XmlElement(name = "agent")
  public Collection<Agent> getAgents() {
    return agents;
  }

  public void setAgents(Collection<Agent> agents) {
    this.agents = agents;
  }
}
