/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management;

import net.sf.ehcache.management.resource.ConfigContainerEntity;
import org.terracotta.management.resource.VersionedEntity;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import java.util.Collection;

/**
 * A top level wrapper for the aggregation of objects extending {@link VersionedEntity}.
 *
 * @author brandony
 */
@XmlRootElement
@XmlSeeAlso({ConfigContainerEntity.class})
public final class AggregateResourceEnvelope<RESOURCE extends VersionedEntity> {

  private Collection<RESOURCE> aggregateResources;

  public Collection<RESOURCE> getAggregateResources() {
    return aggregateResources;
  }


  public void setAggregateResources(Collection<RESOURCE> configContainers) {
    this.aggregateResources = configContainers;
  }
}
