/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management;

import org.terracotta.management.resource.VersionedEntity;

import java.util.ArrayList;
import java.util.Collection;

/**
 * @author brandony
 */
public abstract class AggregateCallback <RESOURCE extends VersionedEntity>{
  private Collection<RESOURCE> responses = new ArrayList<RESOURCE>();

  /**
   * <p>
   * Add a collection of entities to be aggregated.
   * </p>
   *
   * @param response a resource to be included in the aggregate resource
   */
  public void addResponse(RESOURCE response) {
    responses.add(response);
  }

  /**
   * <p>
   * Calculate the collection of aggregate results to be returned.
   * </p>
   *
   * @return aggregate result
   */
  public AggregateResourceEnvelope calculateResult() {
    AggregateResourceEnvelope<RESOURCE> envelope = new AggregateResourceEnvelope<RESOURCE>();
    envelope.setAggregateResources(responses);
    return envelope;
  }

}