/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.userprofile.resource.services;

import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.user.UserRole;
import com.terracotta.management.userprofile.dao.UserProfileDao;
import com.terracotta.management.userprofile.resource.UserProfile;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.terracotta.management.ServiceLocator;

@Path(value="/userprofiles")
public final class UserProfileResourceService {
    private final UserProfileDao usrProfileDao = (UserProfileDao)ServiceLocator.locate(UserProfileDao.class);
    private final Authorizer authorizer = (Authorizer)ServiceLocator.locate(Authorizer.class);

    @GET
    @Path(value="/{userid}")
    @Produces(value={"application/json"})
    public UserProfile retrieveProfile(@PathParam(value="userid") String userid) {
        UserProfile up;
        this.checkAuthorization(userid);
        try {
            up = (UserProfile)this.usrProfileDao.getById((Serializable)((Object)userid));
        }
        catch (DataAccessException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build());
        }
        if (up == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NO_CONTENT).build());
        }
        return up;
    }

    @POST
    @Consumes(value={"application/json"})
    public void addUserProfile(UserProfile userProfile) {
        this.checkAuthorization(userProfile.getId());
        try {
            this.usrProfileDao.create((Object)userProfile);
            this.usrProfileDao.flush();
        }
        catch (DataAccessException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build());
        }
    }

    @PUT
    @Path(value="/{userid}")
    @Consumes(value={"application/json"})
    public void updateUserProfile(@PathParam(value="userid") String userid, UserProfile userProfile) {
        this.checkAuthorization(userid);
        userProfile.setId(userid);
        try {
            this.usrProfileDao.createOrUpdate((Object)userProfile);
            this.usrProfileDao.flush();
        }
        catch (DataAccessException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build());
        }
    }

    @DELETE
    @Path(value="/{userid}")
    public void deleteUserProfile(@PathParam(value="userid") String userid) {
        this.checkAuthorization(userid);
        try {
            UserProfile up = (UserProfile)this.usrProfileDao.getById((Serializable)((Object)userid));
            if (up == null) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.CONFLICT).build());
            }
            this.usrProfileDao.delete((Object)up);
            this.usrProfileDao.flush();
        }
        catch (DataAccessException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build());
        }
    }

    private void checkAuthorization(String userId) {
        if (!this.authorizer.isUserInRole(UserRole.ADMIN) && !this.authorizer.getPrincipal().equals(userId)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }
}

