/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.web.impl;

import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.keychain.URIKeyName;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.security.HMACBuilder;
import com.terracotta.management.security.InvalidIAInteractionException;
import com.terracotta.management.security.InvalidRequestTicketException;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.MaskedUserInfo;
import com.terracotta.management.security.RequestIdentityAsserter;
import com.terracotta.management.security.RequestTicketMonitor;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.services.UserService;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class LicensedIdentityAsserter
implements RequestIdentityAsserter {
    private static final String INVALID_IA_REQ = "Request received from host '%s' is missing the required IA parameters to fullfil this request.";
    private final UserService usrSvc;
    private final RequestTicketMonitor requestTicketMonitor;
    private final Authorizer authorizer;
    private final KeyChainAccessor keyChainAccessor;

    public LicensedIdentityAsserter(Authorizer authorizer, RequestTicketMonitor requestTicketMonitor, UserService usrSvc, KeyChainAccessor keyChainAccessor) {
        this.authorizer = authorizer;
        this.requestTicketMonitor = requestTicketMonitor;
        this.usrSvc = usrSvc;
        this.keyChainAccessor = keyChainAccessor;
    }

    public UserInfo assertIdentity(HttpServletRequest request, HttpServletResponse response) throws InvalidIAInteractionException {
        String sessId = request.getHeader("tc-identity-token");
        String reqTicket = request.getHeader("req-ticket");
        if (reqTicket == null || sessId == null) {
            throw new InvalidIAInteractionException(String.format(INVALID_IA_REQ, request.getRemoteAddr()));
        }
        try {
            this.requestTicketMonitor.redeemRequestTicket(reqTicket);
        }
        catch (InvalidRequestTicketException e) {
            throw new InvalidIAInteractionException(String.format("Request received from host '%s' presented an invalid request ticket.", request.getRemoteAddr()), (Throwable)e);
        }
        String principal = this.authorizer.getPrincipalBySessionId(sessId, true);
        if (principal == null) {
            throw new InvalidIAInteractionException(String.format("Request received from host '%s' presented the currently invalid session id: '%s'", request.getRemoteAddr(), sessId));
        }
        MaskedUserInfo user = new MaskedUserInfo(this.usrSvc.getUser(principal));
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length <= 0) {
            String clientNonce = request.getHeader("client-nonce");
            String alias = request.getHeader("alias");
            if (clientNonce == null || alias == null) {
                throw new InvalidIAInteractionException(String.format(INVALID_IA_REQ, request.getRemoteAddr()));
            }
            try {
                URIKeyName uriAlias = new URIKeyName(alias);
                response.setHeader("signature", HMACBuilder.getInstance((byte[])this.keyChainAccessor.retrieveSecret((KeyName)uriAlias)).addMessageComponent(reqTicket).addMessageComponent(sessId).addMessageComponent(alias).addMessageComponent(clientNonce).addUserDetail((UserInfo)user).buildEncoded());
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("BUG Alert! Failed to create signed hash.", e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("BUG Alert! Failed to create signed hash.", e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("BUG Alert! Unable to determine uri alias for obtaining the key material to sign the hash.", e);
            }
        }
        return user;
    }
}

