/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro;

import com.terracotta.management.security.Authorizer;
import com.terracotta.management.user.UserRole;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public final class ShiroAuthorizer
implements Authorizer {
    public boolean isUserInRole(UserRole role) {
        return SecurityUtils.getSubject().hasRole(role.toString());
    }

    public boolean isUserInAllRoles(Set<UserRole> roles) {
        return SecurityUtils.getSubject().hasAllRoles((Collection)UserRole.convertRoles(roles));
    }

    public boolean isUserInAnyRole(Set<UserRole> roles) {
        boolean[] results;
        for (boolean r : results = SecurityUtils.getSubject().hasRoles(new ArrayList(UserRole.convertRoles(roles)))) {
            if (!r) continue;
            return true;
        }
        return false;
    }

    public String getPrincipal() {
        return SecurityUtils.getSubject().getPrincipal().toString();
    }

    public String getPrincipalBySessionId(String sessionId, boolean isAuthenticated) {
        Object principal;
        Subject subject = new Subject.Builder().sessionId((Serializable)((Object)sessionId)).buildSubject();
        String result = null;
        if (subject != null && (principal = subject.getPrincipal()) != null) {
            result = principal.toString();
            if (isAuthenticated && !subject.isAuthenticated()) {
                result = null;
            }
        }
        return result;
    }

    public String getSessionId() {
        return SecurityUtils.getSubject().getSession().getId().toString();
    }
}

