/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management;

import com.terracotta.license.LicenseManager;
import com.terracotta.management.BuildInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.license.License;

public class UpdateChecker
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger((String)UpdateChecker.class.getName());
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final int CONNECT_TIMEOUT = 3000;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String UPDATE_CHECK_URL = "http://www.terracotta.org/kit/reflector?kitID=tmc&pageID=update.properties";
    private static final long START_TIME = System.currentTimeMillis();
    private final boolean hasLicense;

    public UpdateChecker(boolean hasLicense) {
        this.hasLicense = hasLicense;
    }

    @Override
    public void run() {
        this.checkForUpdate();
    }

    public void checkForUpdate() {
        try {
            this.doCheck();
        }
        catch (Throwable t) {
            LOG.debug("Update check failed", t);
        }
    }

    private void doCheck() throws IOException {
        URL updateUrl = this.buildUpdateCheckUrl();
        if (Boolean.getBoolean("com.terracotta.management.debug.updatecheck")) {
            LOG.info("Update check url: {}", (Object)updateUrl);
        }
        Properties updateProps = this.getUpdateProperties(updateUrl);
        String currentVersion = BuildInfo.VERSION_FULL;
        String propVal = updateProps.getProperty("general.notice");
        if (this.notBlank(propVal)) {
            LOG.info(propVal);
        }
        if (this.notBlank(propVal = updateProps.getProperty(currentVersion + ".notices"))) {
            LOG.info(propVal);
        }
        if (this.notBlank(propVal = updateProps.getProperty(currentVersion + ".updates"))) {
            StringBuilder sb = new StringBuilder();
            String[] newVersions = propVal.split(",");
            for (int i = 0; i < newVersions.length; ++i) {
                String newVersion = newVersions[i].trim();
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(newVersion);
                propVal = updateProps.getProperty(newVersion + ".release-notes");
                if (!this.notBlank(propVal)) continue;
                sb.append(" [");
                sb.append(propVal);
                sb.append("]");
            }
            if (sb.length() > 0) {
                LOG.info("New update(s) found: " + sb.toString() + ". Please check http://terracotta.org for the latest version.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getUpdateProperties(URL updateUrl) throws IOException {
        URLConnection connection = updateUrl.openConnection();
        connection.setConnectTimeout(3000);
        InputStream in = connection.getInputStream();
        try {
            Properties props = new Properties();
            props.load(connection.getInputStream());
            Properties properties = props;
            return properties;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private URL buildUpdateCheckUrl() throws MalformedURLException, UnsupportedEncodingException {
        String url = System.getProperty("tmc.update-check.url", UPDATE_CHECK_URL);
        String connector = url.indexOf(63) > 0 ? "&" : "?";
        return new URL(url + connector + this.buildParamsString());
    }

    private String buildParamsString() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("id=");
        sb.append(this.getClientId());
        sb.append("&os-name=");
        sb.append(this.urlEncode(this.getProperty("os.name")));
        sb.append("&jvm-name=");
        sb.append(this.urlEncode(this.getProperty("java.vm.name")));
        sb.append("&jvm-version=");
        sb.append(this.urlEncode(this.getProperty("java.version")));
        sb.append("&platform=");
        sb.append(this.urlEncode(this.getProperty("os.arch")));
        sb.append("&tc-version=");
        sb.append(BuildInfo.VERSION_FULL);
        sb.append("&tc-product=");
        sb.append(this.urlEncode(BuildInfo.PRODUCT_NAME + " " + BuildInfo.VERSION_FULL));
        sb.append("&source=");
        sb.append(this.urlEncode("TMC"));
        sb.append("&uptime-secs=");
        sb.append(this.getUptimeInSeconds());
        sb.append("&patch=");
        sb.append(UNKNOWN);
        if (this.reportExtras()) {
            sb.append("&type=").append(this.urlEncode(LicenseManager.getLicense().type()));
            sb.append("&number=").append(this.urlEncode(LicenseManager.getLicense().number()));
        }
        return sb.toString();
    }

    private long getUptimeInSeconds() {
        long uptime = System.currentTimeMillis() - START_TIME;
        return uptime > 0L ? uptime / 1000L : 0L;
    }

    private int getClientId() {
        try {
            return InetAddress.getLocalHost().hashCode();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private String urlEncode(String param) throws UnsupportedEncodingException {
        return URLEncoder.encode(param, "UTF-8");
    }

    private String getProperty(String prop) {
        return System.getProperty(prop, UNKNOWN);
    }

    private boolean notBlank(String s) {
        return s != null && s.trim().length() > 0;
    }

    private boolean reportExtras() {
        if (!this.hasLicense) {
            return false;
        }
        License license = LicenseManager.getLicense();
        if (license == null) {
            return false;
        }
        return "BigMemory Go".equals(license.product());
    }
}

