/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.resource.services.impl;

import com.terracotta.management.AggregateCallback;
import net.sf.ehcache.management.resource.ConfigContainerEntity;
import net.sf.ehcache.management.resource.services.CacheConfigsResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

/**
 * @author brandony
 */
@Path("/agents/cacheManagers/caches/configs")
public final class AggregateCacheConfigsResourceService
    extends AggregateEnvelopingResourceServiceSupport<ConfigContainerEntity> implements CacheConfigsResourceService {
  private static final Logger LOG = LoggerFactory.getLogger(AggregateCacheConfigsResourceService.class);

  public AggregateCacheConfigsResourceService() {
    super();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Response getXMLCacheConfigs(UriInfo info) {
    LOG.info(
        String.format("Invoking AggregateCacheConfigsResourceService.getXMLCacheConfigs: %s", info.getRequestUri()));

    getValidator().validateSafe(info);
    AggregateCallback<ConfigContainerEntity> callback = new AggregateCallback<ConfigContainerEntity>() {
    };

    return Response.ok(doGet(info, callback, ConfigContainerEntity.class)).build();
  }
}
