<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<html>
<head>
  <title>Initial TMC Account Setup</title>
  <link rel="shortcut icon" href="${pageContext.request.contextPath}/images/favicon.ico" />
  <link type="text/css" href="${pageContext.request.contextPath}/styles/kendo.common.min.css" rel="stylesheet" />
  <link type="text/css" href="${pageContext.request.contextPath}/styles/kendo.default.min.css" rel="stylesheet" />
  <link type="text/css" href="${pageContext.request.contextPath}/css/monitor.css" rel="stylesheet" />
  <script type="text/javascript" src="${pageContext.request.contextPath}/js/jquery.min.js"></script>
  <script type="text/javascript" src="${pageContext.request.contextPath}/javascript/banner.js"></script> 
  <script type="text/javascript"> 
	  $(document).ready(function() {
	   	var mm = new MarketingManager();
	   	document.setupForm.adminPassword.focus();
	   });
  </script>  
  <style>
    .header {
      height: 100px;
    }
    .formElement {
      margin: 5px;
      padding: 5px;
      border-style: solid;
      border-width: 1px;
    }

    #adminDiv {
      margin-bottom: 20px;
    }
    #operatorDiv {
      margin-bottom: 20px;
    }
    #formDiv {
      border-style: solid;
      border-width: 1px;
      margin-left:30%;
      width: 500px;
      padding:20px;
    }
    .error {
      color: red;
      font-weight: bold;
    }
    label {
      display:block;
      float:left;
      width:225px;
    }
    p {
      font-weight: bold;
      text-align: center;
      margin-bottom: 15px;
    }
    input[type=submit] {
      display:block;
      margin-left: 2px;
    }
  </style>
</head>
<body>
<div id="header">
  <div id="headerContent">
    <div id="tmcLogo"></div>
    <div id="adContent"></div>
  </div>
</div>
<br/>
<div id="formDiv" class="k-content k-state-active">
  <div><p>Welcome to the TMC account setup page.</p> <p>Please enter credentials that you would like to set for the following accounts:</p></div>
    <div align="right">
    <a href="${pageContext.request.contextPath}/tmc-help.html#account-setup" target="_blank">Help</a>
    </div>
  <form name="setupForm" action="${pageContext.request.contextPath}/setup" method="post">
    <div id="adminDiv" class="formElement">
      <div id="adminPassDiv">
        <span class="error">${ADMIN_PWD_ISSUE}</span>
        <label for="adminPassword" id="adminLabel">Enter admin password:</label>
        <input id="adminPassword" type="password" class="k-input" name="adminPassword"/>
      </div>
      <div id="adminConfDiv">
        <label for="adminConfPassword" id="adminConfLabel">Confirm admin password:</label>
        <input id="adminConfPassword" type="password" class="k-input" name="adminConfPassword"/>
      </div>
    </div>
    <div id="operatorDiv" class="formElement">
      <div id="operatorPassDiv">
        <span class="error">${OPER_PWD_ISSUE}</span>
        <label for="operatorPassword" id="operatorLabel">Enter operator password:</label>
        <input id="operatorPassword" type="password" class="k-input" name="operatorPassword"/>
      </div>
      <div id="operatorConfDiv">
        <label for="operatorConfPassword" id="operatorConfLabel">Confirm operator password:</label>
        <input id="operatorConfPassword" type="password" class="k-input" name="operatorConfPassword"/>
      </div>
    </div>
    <input id="setup" type="submit" class="k-button" value="Done"/>
  </form>
</div>

</body>
</html>