<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="shiro" uri="http://shiro.apache.org/tags" %>
<shiro:authenticated>
<% response.sendRedirect("index.jsp"); %>
</shiro:authenticated>
<shiro:notAuthenticated>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
  <title>User Name &amp; Password Authentication</title>
  <link rel="shortcut icon" href="images/favicon.ico" />
  <link type="text/css" href="css/monitor.css" rel="stylesheet" />
  <link type="text/css" href="styles/kendo.common.min.css" rel="stylesheet"/>
  <link type="text/css" href="styles/kendo.default.min.css" rel="stylesheet" />
  
  <script type="text/javascript" src="js/jquery.min.js"></script>
  <script type="text/javascript" src="javascript/banner.js"></script> 
  <script type="text/javascript"> 
	  $(document).ready(function() {
	   	var mm = new MarketingManager();
	   	$("#username").focus();
	   	$("#loginForm").submit(function() {
        $("#loginMsg").removeClass("authError").text("Authenticating. Please wait...");
	   	});
	   });
  </script> 
  <style>
    #elementsDiv {
      margin-top: 20px;
      margin-bottom: 20px;
    }

    #elementsDiv table, input#login {
      margin: 0 auto;
    }
    
    input#login {
      display: block;
      width: 5em;
    }
    
    #formDiv {
      border-style: solid;
      border-width: 1px;
      border-radius: 5px;
      margin: 0 auto;
      width: 425px;
      padding: 20px;
    }

    .authError {
      color: red;
    }

    p {
      text-align: center;
      font-weight: bold;
    }
  </style>
</head>
<body>

<div id="header">
  <div id="headerContent">
    <div id="tmcLogo"></div>
    <div id="adContent"></div>
  </div>
</div>
<br /><br />
<div id="formDiv" class="k-content k-state-active">
    <c:choose>
      <c:when test="${shiroLoginFailure != null}">
        <p id="loginMsg" class="authError">Authentication Failure! Please try again.</p>
      </c:when>
      <c:otherwise>
        <p id="loginMsg">Please login</p>
      </c:otherwise>
    </c:choose>
    <form id="loginForm" action="" method="post">

      <div id="elementsDiv">
        <table cellspacing="3" cellpadding="3" border="0">
          <tr>
            <td align="right">Username:</td>
            <td>
              <input id="username" type="text" name="username"/>
            </td>
          </tr>
          <tr>
            <td align="right">Password:</td>
            <td>
              <input id="password" type="password" name="password"/>
            </td>
          </tr>
        </table>
      </div>

      <input id="login" type="submit" class="k-button" value="Login"/>
    </form>
</div>
</body>
</html>
</shiro:notAuthenticated>