(function($) {
  var kendo = window.kendo,
      ui = kendo.ui,
      Grid = ui.Grid

  var TGrid = Grid.extend({
    init: function(element, options) {
      var that = this;
      
      that._refreshHandler = $.proxy(that.refreshPager, that);
      that._clickHandler = $.proxy(that._click, that);
      
      Grid.fn.init.call(that, element, options);

      that._postSetDataSource();

      that.uids = [];
      that.bind("dataBinding", $.proxy(that._dataBinding, that));
      that.bind("dataBound", $.proxy(that._dataBound, that));
    },

    options: {
      name: "TGrid",
    },

    _dataBinding: function(e) {
      var that = this;
      
      that.uids = [];
      that.table.find(".k-state-selected").each(function() {
        that.uids.push($(this).data("uid"));
      });
    },
    
    _dataBound: function(e) {
      var that = this;
      
      if (that.uids.length != 0) {
        for (var i = 0; i < that.uids.length; i++) {
          var curr_uid = that.uids[i];
          that.table.find("tr[data-uid='" + curr_uid + "']").addClass("k-state-selected");
        }
      }
    },
    
    refreshPager: function() {
      var that = this;
      
      if (that.pager) {
      	that.pager.refresh();
        that.testHidePager();
      }
    },
    
    _click: function(e) {
      var page = $(e.currentTarget).attr(kendo.attr("page"));
      e.preventDefault();

      this.dataSource.page(page);

      this.refreshPager();
    },

    setDataSource: function(dataSource) {
      var that = this;
      
      Grid.fn.setDataSource.call(that, dataSource);

      that._postSetDataSource();
    },
    
    _postSetDataSource: function() {
      var that = this,
        dataSource = that.dataSource;
      
      if (that.pager) {
        that.pager.destroy();      

        dataSource.bind("change", that._refreshHandler);
        that.pager.element.delegate("a", "click", that._clickHandler);
        
        that.refreshPager();
      }
    },
    
    clear: function() {
      var that = this;
      
      that.dataSource.clear();
      that.refreshPager();
    },
    
    getModel: function(key) {
      return this.dataSource.get(key);
    },
    
    removeModel: function(key) {
      var model = this.getModel(key); 
      if (model != null) {
        var result = this.dataSource.remove(model);
        this.refreshPager();
        return result;
      }
    },
    
    selectModel: function(key) {
      this.selectItem(this.getModel(key));
    },
    
    selectItem: function(model) {
      var that = this;
      
      if (model != null) {
        var index = that.dataSource.view().indexOf(model)

        if (index != -1) {
          that.selectRow(index);
        } else {
          that.clearSelection();
        }
      }
    },
    
    selectRow: function(index) {
      if (index < this.dataSource.total()) {
        var row = this.tbody.find(">tr:eq("+index+")");
        if (row.length > 0) {
          this.select(row);
        }
      }
    },
    
    getSelection: function() {
      var that = this,
        selection = that.select();
      
      return selection ? that.dataItem(selection) : null;
    },
    
    updateModel: function(key, entry) {
      var that = this
        ds = that.dataSource,
        model = ds.get(key);
  
      if (model != null) {
        $.extend(model, entry);

        var rowSelector = "tr[" + kendo.attr("uid") + "=" + model.uid +"]",
          row = that.tbody.find(rowSelector),
          detailsAnchorSelector = "td.k-hierarchy-cell > a",
          detailsAnchor = row.find(detailsAnchorSelector),
          detailsCellAnchorClass = detailsAnchor ? detailsAnchor.attr("class") : null,
          selected = row.hasClass("k-state-selected");

        that._modelChange({model: model, field: ""});

        row = that.tbody.find(rowSelector);
        if (selected) {
          row.addClass("k-state-selected");
        }
        if (detailsCellAnchorClass) {
          row.find(detailsAnchorSelector).attr("class", detailsCellAnchorClass);
        }
      } else {
        ds.add(entry);
      }
      
      that.refreshPager();
    },
     
    testHidePager: function() {
      var that = this,
        $pager = $(that.wrapper).find(".k-grid-pager"); 

      if (that.dataSource.totalPages() > 1) {
        $pager.show();
      } else {
        $pager.hide();
      }
    }
  });

  ui.plugin(TGrid);
})(jQuery);