<%@page import="org.terracotta.management.ServiceLocator"%>
<%@ page import="com.terracotta.management.security.web.shiro.TMSEnvironmentLoaderListener" %>
<%@ page import="com.terracotta.management.security.Authorizer" %>
<%@ page import="com.terracotta.management.user.UserRole" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="shiro" uri="http://shiro.apache.org/tags" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
  <title>Terracotta Management Console</title>
  <meta http-equiv="Pragma" content="no-cache">
  <meta http-equiv="Cache-Control" content="no-cache">
  <meta http-equiv="Expires" content="Sat, 01 Dec 2001 00:00:00 GMT">

  <link rel="shortcut icon" href="images/favicon.ico" />
  <link type="text/css" href="styles/kendo.common.min.css" rel="stylesheet" />
  <link type="text/css" href="styles/kendo.default.min.css" rel="stylesheet" />
  <link type="text/css" href="css/monitor.css" rel="stylesheet" />
  <script type="text/javascript" src="js/jquery.min.js"></script>
  <script type="text/javascript" src="js/jquery.ba-resize.js"></script>  
  <script type="text/javascript" src="js/jquery.idle-timer.js"></script>  
  <script type="text/javascript" src="js/kendo.all.min.js"></script>
  <script type="text/javascript" src="js/kendo.data.ext.js"></script>
  <script type="text/javascript" src="js/kendo.grid.ext.js"></script>
  <script type="text/javascript" src="js/kendo.treeview.ext.js"></script>
  <script type="text/javascript" src="js/scroll-events.js"></script>
  <script type="text/javascript" src="js/json2.js"></script>
  <script type="text/javascript" src="js/vkbeautify.0.97.00.beta.js"></script>
  <script type="text/javascript" src="javascript/stdio.js"></script>
  <script type="text/javascript" src="javascript/about.js"></script>
  <script type="text/javascript" src="javascript/agent.config.js"></script>
  <script type="text/javascript" src="javascript/connection.manager.js"></script>
  <script type="text/javascript" src="javascript/settings.manager.js"></script>
  <script type="text/javascript" src="javascript/navigator.page.ui.js"></script>
  <script type="text/javascript" src="javascript/navigator.group.ui.js"></script>
  <script type="text/javascript" src="javascript/navigator.category.ui.js"></script>
  <script type="text/javascript" src="javascript/navigator.agent.ui.js"></script>
  <script type="text/javascript" src="javascript/agent.page.ui.js"></script>
  <script type="text/javascript" src="javascript/agent.topology.ui.js"></script>
  <script type="text/javascript" src="javascript/agent.monitoring.ui.js"></script>
  <script type="text/javascript" src="javascript/cache.config.editor.js"></script>
  <script type="text/javascript" src="javascript/cachemanager.config.editor.js"></script>
  <script type="text/javascript" src="javascript/agent.management.ui.js"></script>
  <script type="text/javascript" src="javascript/agent.diagnostics.ui.js"></script>
  <script type="text/javascript" src="javascript/banner.js"></script>

  <script type="text/javascript">
    var $mainSplitter;
    var kMainSplitter;
    var $navigator;
    var $contentArea;
    var marketingManager;
    var connectionManager;
    var aboutWindow;
    var connections = {};
    var timerHandle;
    var timerInterval = 5000;
    var historySampleCount = 30;
    var timerTime;
    var idleTimeoutMinutes = <%= pageContext.getServletContext().getInitParameter("idleTimeoutMinutes") %>;
    var inAdminRole = <%= TMSEnvironmentLoaderListener.HAS_LICENSE == false || ServiceLocator.locate(Authorizer.class).isUserInRole(UserRole.ADMIN) %>;

    var KBYTE = 1024;
    var MBYTE = KBYTE * KBYTE;
    var GBYTE = MBYTE * KBYTE;

    var EHCACHE = "Ehcache";
    
    $.extend({
      compareArrays: function (a, b) {
        if (a.length != b.length) { return false; }
        for (var i = 0, l = a.length; i < l; i++) {
          if (a[i] !== b[i]) { 
            return false;
          }
        }
        return true;
      }
    });
    
    $.xhrPool = [];
    $.xhrPool.suspend = function() {
      clearPollTimer();
      $(this).each(function(idx, jqXHR) {
        jqXHR.abort();
      });
      $.xhrPool.length = 0
    };
    $.xhrPool.resume = function() {
      var millis = 10;
      if (timerTime != null) {
        var elapsedTime = $.now() - timerTime;
        if (elapsedTime < timerInterval) {
          millis = timerInterval - elapsedTime;
        }
      }
      setPollTimer(millis);
    };
    $.xhrPool.reset = function() {
      $.xhrPool.suspend();
      $.xhrPool.resume();
    };

    $.ajaxSetup({
      beforeSend: function(jqXHR, settings) {
        if (settings.cancelable == undefined || settings.cancelable === true) {
          $.xhrPool.push(jqXHR);
        }
      },
      complete: function(jqXHR) {
        var index = $.xhrPool.indexOf(jqXHR);
        if (index > -1) {
          $.xhrPool.splice(index, 1);
        }
      }
    });
    
    $(function() {
      $container = $("#container");
      $navigator = $("#navigator").kendoTTreeView({
        select: handleNavigatorSelection
      });
      $contentArea = $("#contentArea");
      
      <%-- only start ads if have a real license --%>
      <% if (!TMSEnvironmentLoaderListener.HAS_LICENSE || !TMSEnvironmentLoaderListener.LICENSE_IS_COMMERCIAL_LICENSE ) { %>
      marketingManager = new MarketingManager();
      <% } %>
      
      $mainSplitter = $("#container > #splitter");
      kMainSplitter = $mainSplitter.kendoSplitter({
        panes: [
          {collapsible: true, size: "15%"},
          {collapsible: false, scrollable: false}
        ]
      }).data("kendoSplitter");

      aboutWindow = new AboutWindow();
      connectionManager = new ConnectionManager();
      settingsManager = new SettingsManager();
            
      var groupAndConnectionLoader = function() {
        loadGroups().done(function() {
          loadConnections().always(function() {
            setPollTimer(10);
          });
        });
      };
      loadUserProfile().done(function(data) {
        if (data != null) {
          userProfile = data;
          if (typeof(userProfile.statisticsPollingIntervalMillis) == 'number') {
            timerInterval = userProfile.statisticsPollingIntervalMillis;
          }
          groupAndConnectionLoader.call();
        } else {
          createUserProfile().done(function() {
            groupAndConnectionLoader.call();
          });
        }
      });

      loadAuthenticationEnabled().done(function(data) {
          if (data != null) {
            authenticationEnabled = data;
          } 
        });
      
      function _resize(e) {
        var offset = $mainSplitter.offset();
        $mainSplitter.height($container.height() - offset.top);
      }
      
      $container.bind("resize", _resize);
      $container.trigger("resize");

      if (typeof(idleTimeoutMinutes) == 'number') {
        $.idleTimer(idleTimeoutMinutes * 60 * 1000);
        $(document).bind("idle.idleTimer", function() {
          window.location = "${pageContext.request.contextPath}/logout";
        });
      }
    });

    function manageSettings() {
      settingsManager.show();
    }
    
    function manageConnections() {
      connectionManager.show();
    }

    function loadUserProfile() {
      var user = "<%= ServiceLocator.locate(Authorizer.class).getPrincipal()%>";
      var jqxhr = $.ajax({
        type: "GET",
        url: "api/userprofiles/" + user,
        dataType: "json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        var msg = "Failed to load user profile";
        handleError(msg, jqXHR, textStatus, errorThrown);
      });
      return jqxhr;
    }

    
    function loadAuthenticationEnabled() {
        var jqxhr = $.ajax({
          type: "GET",
          url: "api/config/authentication/",
          dataType: "json"
        }).error(function(jqXHR, textStatus, errorThrown) {
          var msg = "Failed to load authentication status";
          handleError(msg, jqXHR, textStatus, errorThrown);
        });
        return jqxhr;
      }
    
    function createUserProfile() {
      var id = "<%= ServiceLocator.locate(Authorizer.class).getPrincipal()%>";
      var newUserProfile = {
        id: id,
        statisticsPollingIntervalMillis: 5000
      };
      
      var jqxhr = $.ajax({
        type: "POST",
        url: "api/userprofiles/",
        success: function(data) {
          userProfile = newUserProfile;
        },
        processData: false,
        data: JSON.stringify(newUserProfile, null, 2),
        contentType: "application/json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        var msg = "Failed to create user profile";
        handleError(msg, jqXHR, textStatus, errorThrown);
      });
      return jqxhr;
    }

    function updateUserProfile(theUserProfile) {
      theUserProfile.id = "<%= ServiceLocator.locate(Authorizer.class).getPrincipal()%>";
      
      var jqxhr = $.ajax({
        type: "PUT",
        url: "api/userprofiles/" + theUserProfile.id,
        success: function(data) {
          userProfile = theUserProfile;
          if (typeof(userProfile.statisticsPollingIntervalMillis) == 'number') {
            timerInterval = userProfile.statisticsPollingIntervalMillis;
          }
          $(document).trigger("tmc.userProfileChanged");
        },
        processData: false,
        data: JSON.stringify(theUserProfile, null, 2),
        contentType: "application/json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        var msg = "Failed to update user profile";
        handleError(msg, jqXHR, textStatus, errorThrown);
      });
      return jqxhr;
    }
    
    function updateAuthentication(authenticationEnabled) {
        var jqxhr = $.ajax({
          type: "PUT",
          url: "api/config/authentication/" ,
          success: function(data) {
				//reload the page
            	setTimeout(function(){
				   window.location.reload(1);
				}, 2000);
          },
          processData: false,
          data: JSON.stringify(authenticationEnabled),
          contentType: "application/json"
        }).error(function(jqXHR, textStatus, errorThrown) {
          var msg = "Failed to update authentication enablement";
          handleError(msg, jqXHR, textStatus, errorThrown);
        });
        return jqxhr;
      }
    
    function loadGroups() {
      var jqxhr = $.ajax({
        type: "GET",
        url: "api/config/groups",
        success: function(data) {
          $.each(data, function(index, value) {
            if (connections[value] == null) {
              connections[value] = {};
            }
          });
        },
        dataType: "json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        var msg = "Failed to load groups";
        handleError(msg, jqXHR, textStatus, errorThrown);
      });
      return jqxhr;
    }
    
    function loadConnections() {
      var jqxhr = $.ajax({
        type: "GET",
        url: "api/config/agents",
        success: function(data) {
          alphaSort(data, "name");
          $.each(data, function(index, value) {
            registerAgent(value);
          });
          if (Object.keys(connections).length == 0) {
            manageConnections();
          }
        },
        dataType: "json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        var msg = "Failed to load connections";
        handleError(msg, jqXHR, textStatus, errorThrown);
      });
      
      return jqxhr;
    }

    function handleAgentsResponse(data) {
      var groups = {};
      var activeConnections = {};
      var kNavigator = $navigator.data("kendoTTreeView");
      
      alphaSort(data, "agentId");

      var groupNames = $.map(connections, function(agents, groupName) { return groupName; });
      $.each(groupNames, function(index, groupName) {
        var thisGroup = $navigator.find("ul > li").filter(function() { 
          return $(this).data("group") == groupName;
        });
        
        if (thisGroup.length == 0) {
          kNavigator.append({text: groupName})
            .addClass("navigatorGroup")
            .data("group", groupName);
        }
      });
      
      $.each(data, function(index, value) {
        var agentId = value.agentId;
        var idElems = agentId.split("_");
        var group = idElems[0];
        var connectionName = idElems[1];
        var connection = connections[group][connectionName];
        var groupItem = $navigator.find("ul > li").filter(function() { 
          return $(this).data("group") == group;
        });
        
        groups[group] = group;
        if (connection.isEnabled()) {
          activeConnections[agentId] = connection;
        }
        
        if (connection.enabled === true) {
          var categoryItem = groupItem.find("ul > li.navigatorCategory").filter(function() { 
            return $(this).data("category") == EHCACHE;
          });
          
          if (categoryItem.length == 0) {
            categoryItem = kNavigator.append({text: EHCACHE}, groupItem)
              .addClass("navigatorCategory")
              .data("category", EHCACHE)
              .data("group", group);
          }
  
          var connectionItem = categoryItem.find("ul > li.navigatorAgent").filter(function() { 
            return $(this).data("agent") == connectionName;
          });
          if (connectionItem.length == 0) {
            connectionItem = kNavigator.append({text: connectionName}, categoryItem)
              .addClass("navigatorAgent")
              .data("agent", connectionName)
              .data("category", EHCACHE)
              .data("group", group);
          }
        }
      });

      $navigator.find(".navigatorGroup").each(function(i) {
        var navigatorGroup = $(this);

        navigatorGroup.find("li.navigatorCategory").each(function(j) {
          var groupCategory = $(this);

          groupCategory.find("li.navigatorAgent").each(function(k) {
            var navigatorAgent = $(this),
              group = navigatorAgent.data("group"),
              connectionName = navigatorAgent.data("agent"),
              connectionGroup = connections[group],
              connection = connectionGroup != null ? connectionGroup[connectionName] : null;
             
            if (connection == null || activeConnections[connection.getId()] == null) {
              var selected = navigatorAgent.children("span.k-state-selected");

              navigatorAgent.remove();
              if (selected.length > 0) {
                kNavigator.select(groupCategory);
                handleNavigatorSelection({node: groupCategory.get(0)});
              }
            }
          });
          if (groupCategory.find("li.navigatorAgent").length == 0) {
            var selected = groupCategory.children("span.k-state-selected");
            
            groupCategory.remove();
            if (selected.length > 0) {
              kNavigator.select(navigatorGroup);
              handleNavigatorSelection({node: navigatorGroup.get(0)});
            }
          }
        });

        var group = navigatorGroup.data("group");
        if (connections[group] == null) {
          kNavigator.remove(navigatorGroup);
          if (groups[group]) {
            delete groups[group];
          }
        }
      });

      var $selected = kNavigator.select();
      if ($selected.length == 0) {
        var $groups = $navigator.find(".navigatorGroup");

        if ($groups.length > 0) {
          var $group = $groups.get(0);

          kNavigator.expand($group);
          kNavigator.select($group);
          handleNavigatorSelection({node: $group});
        }
      }
      
      var currentPage = $navigator.data("currentPage");
      if (currentPage) {
        currentPage.refresh();
      }
    }
    
    function handleResponseComplete() {
      var currentPage = $navigator.data("currentPage"),
        pollIntervalSeconds;
      
      if (currentPage != null) {
        pollIntervalSeconds = currentPage.getPollIntervalSeconds();
      }
      
      if (pollIntervalSeconds != null) {
        timerInterval = pollIntervalSeconds * 1000;
      } else {
        timerInterval = userProfile.statisticsPollingIntervalMillis;
      }
       
      setPollTimer(timerInterval);
    }

    function clearPollTimer() {
      if (timerHandle) {
        clearTimeout(timerHandle);
        timerHandle = null;
      }
    }
        
    function setPollTimer(waitMillis) {
      if (timerTime) {
        var diff = $.now() - timerTime; 
        if (diff > waitMillis) {
          waitMillis = 0;
        } else {
          waitMillis -= diff;
        }
      }

      timerHandle = setTimeout($.proxy(window.poll, window), waitMillis);
    }
    
    function handleNavigatorSelection(e) {
      var $node = $(e.node);
      var page = $node.data("page");
      var currentPage = $navigator.data("currentPage");
      
      if (!page || (page != currentPage)) {
        if (!page) {
          var agent = $node.data("agent");
          var groupId = $node.data("group");
          var category = $node.data("category");

          if (agent) {
            page = new NavigatorAgentPage(agent, groupId, category);
          } else if (category) {
            page = new NavigatorCategoryPage(groupId, category);
          } else {
            page = new NavigatorGroupPage(groupId); 
          }

          $node.data("page", page);
        }

        if (currentPage) {
          currentPage.unbind("tmc.responseComplete", handleResponseComplete);
          $.xhrPool.suspend();
          currentPage.hide();
        }

        if (page) {
          page.show();
          page.bind("tmc.responseComplete", handleResponseComplete);
          $.xhrPool.resume();
        }
  
        $navigator.data("currentPage", page);
      }
    }
    
    function shouldRetry() {
      var result = true;
      
      if (!window.agentsPollRetries) {
        window.agentsPollRetries = 1;
      } else if (window.agentsPollRetries++ >= 3) {
        delete window.agentsPollRetries;
        result = false;
      }
      
      return result;
    }
    
    function poll() {
      clearPollTimer();
      var jqxhr = $.ajax({
        type: "GET",
        url: "api/agents",
        success: handleAgentsResponse,
        dataType: "json"
      }).error(function(jqXHR, textStatus, errorThrown) {
        if (textStatus != "abort") {
          if (shouldRetry()) {
            var msg = "Failed to load agents";
            handleError(msg, jqXHR, textStatus, errorThrown);
            setPollTimer(timerInterval);
          } else {
            window.location.reload();
          }
        }
      });
      timerTime = $.now();
    }

    function registerAgent(agentAttrs) {
      var agentConfig = new AgentConfig(agentAttrs),
        groupId = agentConfig.getGroupId(),
        name = agentConfig.getName();

      if (connections[groupId] == null) {
        connections[groupId] = {};
      }
      connections[groupId][name] = agentConfig;
      
      return agentConfig;
    }

    function clearContentArea() {
      $contentArea.children().hide();
    }
    
    function handleError(msg, jqXHR, textStatus, errorThrown) {
      switch (jqXHR.status) {
        case 12029:
          msg += "; a connection to the server could not be created";
          break;
        case 400:
          msg += "; " + textStatus;
          break;
        case 409:
          msg += "; the name you specified is already in use, please choose another one";
          alert(msg);
          break;
        default:
          msg += "; " + errorThrown;
      }
      window.status = msg;
      // alert(msg);
    }
    
    function setupHelpLink(helpLinkElement, helpUrl) {
      helpLinkElement.click(function(e) {
          window.open('tmc-help.html#manage-connections');
            e.preventDefault();
        });
      helpLinkElement.removeClass("k-icon");
      helpLinkElement.addClass("helpLink");
      helpLinkElement.parent().removeClass("k-window-action");
    }
    
    // TODO: move the utilities into their own module
    
    function concatUnique(array1, array2) {
      var map = {},
        result;
        
      $.each(array1, function(index, value) { map[value] = value; });
      $.each(array2, function(index, value) { map[value] = value; });
      
      result = $.map(map, function(value, key) {
        return key;
      });
      
      return result;
    }

    function remainingHeight($target, height) {
      $target.siblings("*").each(function(index, element) {
        var $el = $(element);
        if ($el.is(":visible")) {
          height -= $el.outerHeight(true);
        }
      });
      return height > 0 ? height : 0;
    }

    function assignRemainingHeight($target) {
      var result = remainingHeight($target, $target.parent().height());
      $target.height(result);
      return result;
    }

    function resizeHandler($target, workerFunc) {
      $target.bind("resize.tmc", function(e) {
        if ($target.is(":visible")) {
          $target.unbind("resize.tmc", arguments.callee);

          var stopPropagation = true;
          if (arguments.length == 3) {
            stopPropagation = (arguments[2] === false);
          }
          if (stopPropagation) {
            e.stopPropagation();
          }
          
          try {
            workerFunc.call(e);
          } catch (ex) {
            alert(ex.toString());
          }

          $target.bind("resize.tmc", arguments.callee);
        }
      });
    }
    
    function htmlEncode(value) {
      var pos = 0, c, encoded = [];

      if(value == null)
          return '';

      while (pos < value.length) { 
        c = value.charAt(pos++);
        
        switch (c) {
        case '<':
          encoded.push('&lt;');
          break;
        case '>':
          encoded.push('&gt;');
          break;
        case '&':
          encoded.push('&amp;');
          break;
        case '"':
          encoded.push('&quot;');
          break;
        case "'":
          encoded.push('&#39;');
          break;
        case ' ':
          encoded.push('%20');
          break;
        case '\r':
          encoded.push(' ');
          break;
        case '\n':
          encoded.push(' ');
          break;
        case '\t':
          encoded.push(' ');
          break;
        default:
          if (c < ' ' || c > '~') {
            encoded.push('&#' + c.charCodeAt(0) + ';'); // escape, and put in byte value
          } else {
            encoded.push(c);
          }
        }
      }

      return encoded.join('');
    };

    function formatInt(n) {
      return kendo.toString(n, "##,#");
    }
    
    function formatIntRightJustified(n) {
      return "<div style='text-align:right;'>"
        + formatInt(n)
        + "</div>";
    }

    var DEFAULT_FLOAT_PLACES = 1;
    
    function formatFloat(n) {
      var pattern = "n";
      var places = DEFAULT_FLOAT_PLACES;
      
      if (arguments[1]) {
        places = arguments[1];
      }
      
      if ($.isNumeric(places)) {
        pattern += places.toFixed();
      }
      return kendo.toString(n, pattern);
    }
    
    function formatFloatRightJustified(n) {
      var places = DEFAULT_FLOAT_PLACES;
      
      if (arguments[1]) {
        places = arguments[1];
      }

      return "<div style='text-align:right;'>"
        + formatFloat(n, places)
        + "</div>";
    }

    function formatPercentage(n) {
      return kendo.toString(n, "p");
    }
    
    function formatPercentageRightJustified(n) {
      return "<div style='text-align:right;'>"
        + formatPercentage(n)
        + "</div>";
    }
    
   function toMegabytes(n) {
      if (n == 0) {
        return 0;
      }
      return n/MBYTE;
    }
    
    function calculateHitRatio(hits, misses) {
      if (hits == 0) {
        return 0;
      }
      return hits/(hits+misses);
    }
    
    function alphaSort(array, fieldName) {
      array.sort(function(a, b) {
        var aVal = a[fieldName], bVal = b[fieldName];
        
        if (aVal < bVal) {
          return -1;
        } else if (aVal > bVal) {
          return 1;
        } else {
          return 0;
        }
      });
    }      
  </script>
</head>

<body>
<div id="container" style="overflow:hidden;">
  <%-- only start ads if we do not have a real license --%>
  <% if (!TMSEnvironmentLoaderListener.HAS_LICENSE || !TMSEnvironmentLoaderListener.LICENSE_IS_COMMERCIAL_LICENSE ) { %>
  <div id="header">
    <div id="headerContent">
      <div id="tmcLogo"></div>
      <div id="adContent"></div>
    </div>
  </div>
  <% } else { %>
  <div id="headerLicensed">
    <div id="headerContentLicensed">
      <div id="tmcLogoLicensed"></div>
    </div>
  </div>
  <% } %>

  <div id="menu" class="gradient">
    <% if (TMSEnvironmentLoaderListener.HAS_LICENSE == false ||
        ServiceLocator.locate(Authorizer.class).isUserInRole(UserRole.ADMIN)) { %>
    <a href="javascript:connectionManager.show();" class="menuManage"><div class="menuItem" id="manageConnections">Manage Connections</div></a>
    <% } %>
    <a href="javascript:manageSettings();" class="menuSettings"><div class="menuItem" id="settings">Settings</div></a>
    <a href="javascript:aboutWindow.show();" class="menuAbout"><div class="menuItem" id="aboutMenuItem">About</div></a>
    <a href="tmc-help.html" target="_blank" class="menuHelp"><div class="menuItem">Help</div></a>
    <% if (TMSEnvironmentLoaderListener.HAS_LICENSE) { %>
    <a id="logout" href="${pageContext.request.contextPath}/logout"><div class="menuLogout">Logout</div></a>
    <% } %>
  </div>

  <div id="connection-manager">
    <jsp:include page="connection-manager.jsp" />
  </div>
  
  <div id="settings-manager">
    <jsp:include page="settings-manager.jsp" />
  </div>

  <div id="navigator-group" style="padding-right:5px;">
    <jsp:include page="navigator-group.jsp" />
  </div>
  
  <div id="navigator-category">
    <jsp:include page="navigator-category.jsp" />
  </div>
  
  <div id="navigator-agent">
    <jsp:include page="navigator-agent.jsp" />
  </div>
  
  <div id="splitter">
    <div id="navigator"></div>
    <div id="contentArea"></div>
  </div>

  <div id="about-dialog">
    <jsp:include page="about.jsp" />
  </div>
  
  <div id='alert' style='display:none;padding:1em;'>
    <p id='msg' style='height:4em;'/>
    <table cellspacing='1' cellpadding='3' border='0' style='width:100%;'>
      <tr>
        <td width='100%' align='center'>
          <button type='button' id='accept' class='k-button' style='width:100px;'>OK</button>
        </td>
      </tr>
    </table>
  </div>

  <div id='confirm' style='display:none;padding:1em;'>
    <p id='msg' style='height:4em;'/>
    <table cellspacing='1' cellpadding='3' border='0' style='width:100%;'>
      <tr>
        <td width='50%' align='right'>
          <button type='button' id='accept' class='k-button' style='width:100px;'>OK</button>
        </td>
        <td width='50%'>
          <button type='button' id='cancel' class='k-button' style='width:100px;'>Cancel</button>
        </td>
      </tr>
    </table>
  </div>

  <div id='prompt' style='display:none;padding:1em;'>
    <p id='msg' style='height:4em;'/>
    <div>
      <input type='text' id='input' name='input'></input>
    </div>
    <table cellspacing='1' cellpadding='3' border='0' style='width:100%;'>
      <tr>
        <td width='50%' align='right'>
          <button type='button' id='accept' class='k-button' style='width:100px;'>OK</button>
        </td>
        <td width='50%'>
          <button type='button' id='cancel' class='k-button' style='width:100px;'>Cancel</button>
        </td>
      </tr>
    </table>
  </div>
</div>
</body>
</html>
