/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.userprofile.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAttribute;

public final class UserProfile {
    private static final Long DFLT_DISPLAY_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final List<String> DFLT_EHCACHE_CHARTED_STATISTICS = new ArrayList<String>(Arrays.asList("CacheHitRate", "CacheMissRate", "CachePutRate", "CacheAverageGetTime"));
    private static final List<String> DFLT_EHCACHE_GRID_STATISTICS = new ArrayList<String>(Arrays.asList("CacheHitRate", "CacheMissRate", "Size", "LocalHeapSize", "LocalHeapSizeInBytes", "LocalHeapSize", "LocalHeapSizeInBytes", "CacheAverageGetTime"));
    private String id;
    private Long intervalMillis;
    private List<String> ehcacheChartedStatistics;
    private List<String> ehcacheGridStatistics;

    public UserProfile() {
    }

    public UserProfile(String id, Long intervalMillis, List<String> ehcacheChartedStatistics, List<String> ehcacheGridStatistics) {
        this.id = id;
        this.intervalMillis = intervalMillis;
        this.ehcacheChartedStatistics = ehcacheChartedStatistics;
        this.ehcacheGridStatistics = ehcacheGridStatistics;
    }

    @XmlAttribute
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute
    public Long getStatisticsPollingIntervalMillis() {
        return this.intervalMillis == null ? DFLT_DISPLAY_INTERVAL_MILLIS : this.intervalMillis;
    }

    public void setStatisticsPollingIntervalMillis(Long intervalMillis) {
        this.intervalMillis = intervalMillis;
    }

    @XmlAttribute
    public List<String> getEhcacheChartedStatistics() {
        return this.ehcacheChartedStatistics != null ? new ArrayList(this.ehcacheChartedStatistics) : DFLT_EHCACHE_CHARTED_STATISTICS;
    }

    public void setEhcacheChartedStatistics(List<String> ehcacheChartedStatistics) {
        this.ehcacheChartedStatistics = ehcacheChartedStatistics;
    }

    @XmlAttribute
    public List<String> getEhcacheGridStatistics() {
        return this.ehcacheGridStatistics != null ? new ArrayList(this.ehcacheGridStatistics) : DFLT_EHCACHE_GRID_STATISTICS;
    }

    public void setEhcacheGridStatistics(List<String> ehcacheGridStatistics) {
        this.ehcacheGridStatistics = ehcacheGridStatistics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserProfile that = (UserProfile)o;
        if (this.ehcacheChartedStatistics != null ? !((Object)this.ehcacheChartedStatistics).equals(that.ehcacheChartedStatistics) : that.ehcacheChartedStatistics != null) {
            return false;
        }
        if (this.ehcacheGridStatistics != null ? !((Object)this.ehcacheGridStatistics).equals(that.ehcacheGridStatistics) : that.ehcacheGridStatistics != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.intervalMillis != null ? !this.intervalMillis.equals(that.intervalMillis) : that.intervalMillis != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.intervalMillis != null ? this.intervalMillis.hashCode() : 0);
        result = 31 * result + (this.ehcacheChartedStatistics != null ? ((Object)this.ehcacheChartedStatistics).hashCode() : 0);
        result = 31 * result + (this.ehcacheGridStatistics != null ? ((Object)this.ehcacheGridStatistics).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UserProfile{id='" + this.id + '\'' + ", intervalMillis=" + this.intervalMillis + ", ehcacheChartedStatistics=" + this.ehcacheChartedStatistics + ", ehcacheGridStatistics=" + this.ehcacheGridStatistics + '}';
    }
}

