/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.config;

import com.terracotta.management.config.Agent;
import com.terracotta.management.config.jaxb.adapters.AdaptedConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public final class Config
extends Observable {
    private final ConcurrentHashMap<String, ConcurrentMap<String, Agent>> agentsByGroupById;
    private Boolean authenticationEnabled;

    public Config() {
        this.agentsByGroupById = new ConcurrentHashMap();
    }

    public Config(Map<String, Collection<Agent>> monitored, Boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
        this.agentsByGroupById = new ConcurrentHashMap();
        for (Map.Entry<String, Collection<Agent>> groupEntry : monitored.entrySet()) {
            this.addGroup(groupEntry.getKey());
            for (Agent agent : groupEntry.getValue()) {
                this.addAgent(agent);
            }
        }
    }

    private void agentsChanged(String agentId) {
        this.setChanged();
        this.notifyObservers((Object)agentId);
    }

    public Set<String> getGroups() {
        return Collections.unmodifiableSet(this.agentsByGroupById.keySet());
    }

    public boolean addGroup(String groupId) {
        ConcurrentHashMap old = this.agentsByGroupById.putIfAbsent(groupId, new ConcurrentHashMap());
        return old == null;
    }

    public boolean deleteGroup(String groupId) {
        boolean deleted = false;
        Collection agents = this.getAgentsByGroup(groupId);
        if (agents != null) {
            for (Agent agent : this.getAgentsByGroup(groupId)) {
                this.deleteAgent(agent.getId());
            }
            deleted = this.agentsByGroupById.remove(groupId, Collections.emptyMap());
        }
        return deleted;
    }

    public boolean renameGroup(String oldGroupId, String newGroupId) {
        ConcurrentMap oldGroup = (ConcurrentMap)this.agentsByGroupById.get(oldGroupId);
        if (oldGroup == null) {
            return false;
        }
        ConcurrentHashMap<String, Agent> newGroup = new ConcurrentHashMap<String, Agent>();
        for (Map.Entry entry : oldGroup.entrySet()) {
            Agent oldAgent = (Agent)entry.getValue();
            Agent newAgent = new Agent(oldAgent);
            newAgent.setGroupId(newGroupId);
            newGroup.put(newAgent.getName(), newAgent);
        }
        ConcurrentMap current = this.agentsByGroupById.putIfAbsent(newGroupId, newGroup);
        if (current == null) {
            this.agentsByGroupById.remove(oldGroupId);
            for (Map.Entry entry : oldGroup.entrySet()) {
                this.agentsChanged(((Agent)entry.getValue()).getId());
            }
            for (Map.Entry entry : newGroup.entrySet()) {
                this.agentsChanged(((Agent)entry.getValue()).getId());
            }
            return true;
        }
        return false;
    }

    public Agent getAgent(String agentId) {
        String name = Agent.nameOfId((String)agentId);
        String groupId = Agent.groupOfId((String)agentId);
        ConcurrentMap agentsMap = (ConcurrentMap)this.agentsByGroupById.get(groupId);
        return agentsMap != null ? (Agent)agentsMap.get(name) : null;
    }

    public Collection<Agent> getAgentsByGroup(String groupId) {
        ConcurrentMap agentsMap = (ConcurrentMap)this.agentsByGroupById.get(groupId);
        if (agentsMap == null) {
            return null;
        }
        return agentsMap.values();
    }

    public Agent deleteAgent(String agentId) {
        String oldName = Agent.nameOfId((String)agentId);
        String oldGroupId = Agent.groupOfId((String)agentId);
        ConcurrentMap agentsMap = (ConcurrentMap)this.agentsByGroupById.get(oldGroupId);
        if (agentsMap == null) {
            return null;
        }
        Agent oldValue = (Agent)agentsMap.remove(oldName);
        if (oldValue == null) {
            return null;
        }
        this.agentsChanged(agentId);
        return oldValue;
    }

    public boolean addAgent(Agent agent) {
        String name = agent.getName();
        String groupId = agent.getGroupId();
        ConcurrentHashMap<String, Agent> agentsMap = (ConcurrentHashMap<String, Agent>)this.agentsByGroupById.get(groupId);
        if (agentsMap == null) {
            agentsMap = new ConcurrentHashMap<String, Agent>();
            this.agentsByGroupById.put(groupId, agentsMap);
        }
        if (agentsMap.containsKey(name)) {
            return false;
        }
        agentsMap.put(name, agent);
        this.agentsChanged(agent.getId());
        return true;
    }

    public boolean updateAgent(String agentId, Agent agent) {
        String oldName = Agent.nameOfId((String)agentId);
        String oldGroupId = Agent.groupOfId((String)agentId);
        String newName = agent.getName();
        String newGroupId = agent.getGroupId();
        ConcurrentMap oldAgentGroup = (ConcurrentMap)this.agentsByGroupById.get(oldGroupId);
        if (oldAgentGroup == null) {
            return false;
        }
        ConcurrentMap newAgentGroup = (ConcurrentMap)this.agentsByGroupById.get(newGroupId);
        if (newAgentGroup == null) {
            return false;
        }
        if (oldAgentGroup != newAgentGroup && newAgentGroup.containsKey(newName)) {
            return false;
        }
        Agent oldValue = (Agent)oldAgentGroup.remove(oldName);
        if (oldValue == null) {
            return false;
        }
        this.agentsChanged(agentId);
        newAgentGroup.put(newName, agent);
        this.agentsChanged(agent.getId());
        return true;
    }

    public String toString() {
        return "Config{agentsByGroupById=" + this.agentsByGroupById + '}';
    }

    public static Config load(InputStream is) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AdaptedConfig.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        AdaptedConfig ac = (AdaptedConfig)AdaptedConfig.class.cast(jaxbUnmarshaller.unmarshal(is));
        Boolean authenticationEnabled = ac.isAuthenticationEnabled() == null ? null : ac.isAuthenticationEnabled();
        return new Config(ac.getMonitored(), authenticationEnabled);
    }

    public static void write(Config config, File configFile) throws JAXBException, IOException {
        File parent = configFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        configFile.createNewFile();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AdaptedConfig.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        AdaptedConfig ac = new AdaptedConfig();
        ac.setMonitored(config.getMonitored());
        ac.setAuthenticationEnabled(config.isAuthenticationEnabled());
        jaxbMarshaller.marshal((Object)ac, configFile);
    }

    Map<String, Collection<Agent>> getMonitored() {
        HashMap<String, Collection<Agent>> monitored = new HashMap<String, Collection<Agent>>();
        for (String groupId : this.getGroups()) {
            Collection agentsByGroup = this.getAgentsByGroup(groupId);
            monitored.put(groupId, agentsByGroup);
        }
        return monitored;
    }

    public Boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public void setAuthenticationEnabled(Boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
        this.setChanged();
    }
}

