/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.user.services;

import com.terracotta.management.user.UserInfo;
import org.terracotta.management.ServiceExecutionException;

/**
 * An interface for user operations.
 *
 * @author brandony
 */
public interface UserService {
  /**
   * Add a user to the security context.
   *
   * @param user to be added
   * @throws ServiceExecutionException
   */
  void addUser(UserInfo user) throws ServiceExecutionException;

  /**
   * Update a user in the security context.
   *
   * @param user to be updated
   * @throws ServiceExecutionException
   */
  void updateUser(UserInfo user) throws ServiceExecutionException;

  /**
   * Disable a user in the security context. This will prevent this user from future login.
   *
   * @param username for the user to disable
   */
  void disableUser(String username);

  /**
   * Delete a user from the security context.
   *
   * @param user to delete
   * @throws ServiceExecutionException
   */
  void deleteUser(UserInfo user) throws ServiceExecutionException;

  /**
   * Get a user from the security context.
   *
   * @param username to retrieve
   * @return {@link UserInfo} for the username submitted if it exists, {@code null} if not.
   */
  UserInfo getUser(String username);
}
