/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management;

import org.terracotta.management.resource.Representable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/**
 * <p>
 * The default callback implementation for collections of resources.
 * </p>
 * 
 * @author brandony
 */
public abstract class AggregateCollectionCallback<RESOURCE extends Representable> {
  protected Collection<Collection<RESOURCE>> responses = new ArrayList<Collection<RESOURCE>>();

  /**
   * <p>
   * Add a collection of resources to be aggregated.
   * </p>
   * 
   * @param response to aggregate
   */
  public void addResponses(Collection<RESOURCE> response) {
    responses.add(response);
  }

  /**
   * <p>
   * Calculate the collection of aggregate resources to be returned.
   * </p>
   * 
   * @return aggregate result
   */
  public Collection<RESOURCE> calculateResult() {
    Collection<RESOURCE> result = new HashSet<RESOURCE>();

    for (Collection<RESOURCE> r : responses)
      result.addAll(r);

    return result;
  }
}
