/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.userprofile.dao.impl;

import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.userprofile.dao.UserProfileDao;
import com.terracotta.management.userprofile.dao.impl.XMLFileUserProfileDao;
import com.terracotta.management.userprofile.resource.UserProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class XMLFileUserProfileDao
implements UserProfileDao {
    private static final Logger LOG = LoggerFactory.getLogger(XMLFileUserProfileDao.class);
    private static final String DFLT_UPS_FILE_LOCATION = System.getProperty("user.home") + "/.tc/mgmt/usr_profile_settings.xml";
    private static final String JVM_UPS_LOCATION_PROP = "com.tc.management.ups.xml";
    private UserProfileSettings profileSettings;
    private File settingsFile = new File(System.getProperty("com.tc.management.ups.xml") == null ? DFLT_UPS_FILE_LOCATION : System.getProperty("com.tc.management.ups.xml"));

    public XMLFileUserProfileDao() throws IOException, JAXBException {
        if (this.settingsFile.exists()) {
            this.profileSettings = UserProfileSettings.access$000((InputStream)new FileInputStream(this.settingsFile));
        } else {
            this.initSettingsFile();
        }
    }

    public UserProfile getById(String userId) throws DataAccessException {
        return (UserProfile)UserProfileSettings.access$100((UserProfileSettings)this.profileSettings).get(userId);
    }

    public void create(UserProfile userProfile) throws DataAccessException {
        UserProfile up = UserProfileSettings.access$100((UserProfileSettings)this.profileSettings).putIfAbsent(userProfile.getId(), userProfile);
        if (up != null) {
            throw new DataAccessException(String.format("Failed to create user profile '%s' because it already exists.", userProfile));
        }
    }

    public void createOrUpdate(UserProfile userProfile) throws DataAccessException {
        UserProfileSettings.access$100((UserProfileSettings)this.profileSettings).replace(userProfile.getId(), userProfile);
    }

    public void delete(UserProfile userProfile) throws DataAccessException {
        UserProfile up = (UserProfile)UserProfileSettings.access$100((UserProfileSettings)this.profileSettings).remove(userProfile.getId());
        if (up == null) {
            throw new DataAccessException(String.format("Failed to delete user profile '%s' because it does not exist.", userProfile));
        }
    }

    public void flush() {
        try {
            UserProfileSettings.access$200((UserProfileSettings)this.profileSettings, (File)this.settingsFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write user profile settings!", e);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to serialize user profile settings!", e);
        }
    }

    public void evict(UserProfile userProfile) {
        try {
            this.delete(userProfile);
        }
        catch (DataAccessException e) {
            LOG.info("Unable to find userProfile '{}' for eviction.", (Object)userProfile);
        }
    }

    private void initSettingsFile() throws IOException, JAXBException {
        File parent = this.settingsFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        File temp = File.createTempFile("tmp", UUID.randomUUID().toString(), parent);
        temp.renameTo(this.settingsFile);
        this.profileSettings = new UserProfileSettings(null);
        UserProfileSettings.access$200((UserProfileSettings)this.profileSettings, (File)this.settingsFile);
    }
}

