/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.web.shiro;

import com.sun.jersey.api.client.filter.ClientFilter;
import com.terracotta.license.LicenseManager;
import com.terracotta.management.UpdateChecker;
import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.resource.services.validator.impl.AggregateEhcacheRequestValidator;
import com.terracotta.management.security.Authorizer;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.RequestIdentityAsserter;
import com.terracotta.management.security.RequestTicketMonitor;
import com.terracotta.management.security.SecurityContextManager;
import com.terracotta.management.security.impl.DfltRequestTicketMonitor;
import com.terracotta.management.security.impl.DfltSSLContextFactory;
import com.terracotta.management.security.impl.NoSecurityContextAuthorizer;
import com.terracotta.management.security.impl.ObfuscatedSecretFileStoreKeyChainAccessor;
import com.terracotta.management.security.services.SecurityContextSetupService;
import com.terracotta.management.security.services.impl.IniFileSetupService;
import com.terracotta.management.security.shiro.ShiroAuthorizer;
import com.terracotta.management.security.shiro.ShiroSecurityContextManager;
import com.terracotta.management.security.shiro.realm.TCIniRealm;
import com.terracotta.management.security.web.impl.LicensedIdentityAsserter;
import com.terracotta.management.security.web.impl.NoOpIdentityAsserter;
import com.terracotta.management.security.web.jersey.TMSRequestClientFilter;
import com.terracotta.management.security.web.jersey.TMSRequestSecurityClientFilter;
import com.terracotta.management.services.ConfigService;
import com.terracotta.management.services.JerseyClientFactory;
import com.terracotta.management.services.ResourceServiceClientService;
import com.terracotta.management.services.impl.DfltJerseyClientFactory;
import com.terracotta.management.services.impl.FileConfigService;
import com.terracotta.management.services.impl.JerseyResourceServiceClientService;
import com.terracotta.management.user.UserInfoFactory;
import com.terracotta.management.user.dao.impl.IniFileUserInfoDao;
import com.terracotta.management.user.impl.DfltUserInfoFactory;
import com.terracotta.management.user.services.UserService;
import com.terracotta.management.userprofile.dao.UserProfileDao;
import com.terracotta.management.userprofile.dao.impl.XMLFileUserProfileDao;
import java.io.IOException;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.env.WebEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.license.LicenseException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.services.Utils;
import org.terracotta.management.resource.services.validator.RequestValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TMSEnvironmentLoaderListener
extends EnvironmentLoaderListener {
    private static final long EVERY_WEEK = 604800000L;
    private static final long DELAY_UPDATE_CHECK = 1000L;
    public static Boolean HAS_LICENSE;
    public static Boolean LICENSE_IS_COMMERCIAL_LICENSE;
    private static final Logger LOG;
    private Timer updateCheckTimer;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        XMLFileUserProfileDao usrProfileDao;
        this.checkLicense();
        FileConfigService configSvc = new FileConfigService();
        DfltUserInfoFactory usrInfoFactory = new DfltUserInfoFactory();
        try {
            usrProfileDao = new XMLFileUserProfileDao();
        }
        catch (IOException e) {
            throw new RuntimeException("Failure instantiating TMS context because user profile datasource could not be found or initialized.", e);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failure instantiating TMS context due to invalid user profile data format.", e);
        }
        this.loadContextAccordingToLicenseAndAuth(servletContextEvent, (ConfigService)configSvc, (UserInfoFactory)usrInfoFactory, (UserProfileDao)usrProfileDao);
        this.scheduleUpdateCheckIfNeeded();
    }

    void loadContextAccordingToLicenseAndAuth(ServletContextEvent servletContextEvent, ConfigService configSvc, UserInfoFactory usrInfoFactory, UserProfileDao usrProfileDao) {
        if (HAS_LICENSE.booleanValue() && configSvc.isAuthenticationEnabled() != null && configSvc.isAuthenticationEnabled().booleanValue()) {
            this.initEnvironment(servletContextEvent.getServletContext());
            this.loadLicensedCtxt(configSvc, usrInfoFactory, usrProfileDao, servletContextEvent.getServletContext());
        } else {
            this.loadUnlicensedCtxt(configSvc, usrInfoFactory, usrProfileDao);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (HAS_LICENSE.booleanValue()) {
            this.destroyEnvironment(servletContextEvent.getServletContext());
        }
        ServiceLocator.unload();
        if (this.updateCheckTimer != null) {
            this.updateCheckTimer.cancel();
        }
    }

    private void checkLicense() {
        if (HAS_LICENSE == null) {
            try {
                LicenseManager.verifyTMCCapability();
                HAS_LICENSE = true;
                LICENSE_IS_COMMERCIAL_LICENSE = LicenseManager.isCommercialLicense();
            }
            catch (LicenseException e) {
                HAS_LICENSE = false;
            }
        }
    }

    private void loadLicensedCtxt(ConfigService configSvc, UserInfoFactory usrInfoFactory, UserProfileDao usrProfileDao, ServletContext sc) {
        ShiroSecurityContextManager secCtxtMgr;
        ObfuscatedSecretFileStoreKeyChainAccessor keyChainAccessor;
        ShiroAuthorizer authorizer = new ShiroAuthorizer();
        DfltRequestTicketMonitor monitor = new DfltRequestTicketMonitor();
        try {
            keyChainAccessor = new ObfuscatedSecretFileStoreKeyChainAccessor();
        }
        catch (KeychainInitializationException e) {
            throw new RuntimeException("Failure instantiating a licensed TMS (security enabled) due to invalid keychain configuration.", e);
        }
        DfltSSLContextFactory sslCtxtFactory = null;
        if (this.isSSLConfiguredWithKeyStoreAndTrustStore()) {
            LOG.info("SSL configuration with keystore and truststore found, registering a custom sslContextFactory using them");
            sslCtxtFactory = new DfltSSLContextFactory((KeyChainAccessor)keyChainAccessor, System.getProperty("user.home") + "/.tc/mgmt/tms-keystore", System.getProperty("user.home") + "/.tc/mgmt/tms-truststore");
        } else {
            LOG.info("SSL configuration with keystore and truststore NOT found, if you want to use your keystore and trustore, use -Dtms.ia.useSSL=true");
        }
        TMSRequestSecurityClientFilter clientFilter = new TMSRequestSecurityClientFilter((RequestTicketMonitor)monitor, (KeyChainAccessor)keyChainAccessor);
        DfltJerseyClientFactory clientFactory = new DfltJerseyClientFactory((ClientFilter)clientFilter, sslCtxtFactory);
        JerseyResourceServiceClientService rsrcSvcClientSvc = new JerseyResourceServiceClientService(configSvc, (JerseyClientFactory)clientFactory, (Authorizer)authorizer);
        try {
            secCtxtMgr = new ShiroSecurityContextManager(new IniFileUserInfoDao(), this.getInitializedTCIniRealm(sc));
        }
        catch (DataAccessException e) {
            throw new RuntimeException("Failure instantiating TMS context because user info datasource could not be found or initialized.", e);
        }
        IniFileSetupService secCtxtSetupSvc = new IniFileSetupService((UserService)secCtxtMgr, usrInfoFactory);
        LicensedIdentityAsserter idAsserter = new LicensedIdentityAsserter((Authorizer)authorizer, (RequestTicketMonitor)monitor, (UserService)secCtxtMgr, (KeyChainAccessor)keyChainAccessor);
        AggregateEhcacheRequestValidator requestValidator = new AggregateEhcacheRequestValidator((Authorizer)authorizer);
        ServiceLocator locator = new ServiceLocator().loadService(RequestValidator.class, (Object)requestValidator).loadService(ConfigService.class, (Object)configSvc).loadService(ResourceServiceClientService.class, (Object)rsrcSvcClientSvc).loadService(UserProfileDao.class, (Object)usrProfileDao).loadService(Authorizer.class, (Object)authorizer).loadService(RequestIdentityAsserter.class, (Object)idAsserter).loadService(SecurityContextManager.class, (Object)secCtxtMgr).loadService(SecurityContextSetupService.class, (Object)secCtxtSetupSvc);
        ServiceLocator.load((ServiceLocator)locator);
    }

    private void loadUnlicensedCtxt(ConfigService configSvc, UserInfoFactory usrInfoFactory, UserProfileDao usrProfileDao) {
        NoSecurityContextAuthorizer authorizer = new NoSecurityContextAuthorizer();
        DfltJerseyClientFactory clientFactory = new DfltJerseyClientFactory((ClientFilter)new TMSRequestClientFilter(), null);
        JerseyResourceServiceClientService rsrcSvcClientSvc = new JerseyResourceServiceClientService(configSvc, (JerseyClientFactory)clientFactory, (Authorizer)authorizer);
        NoOpIdentityAsserter idAsserter = new NoOpIdentityAsserter(usrInfoFactory);
        AggregateEhcacheRequestValidator requestValidator = new AggregateEhcacheRequestValidator((Authorizer)authorizer);
        ServiceLocator locator = new ServiceLocator().loadService(RequestValidator.class, (Object)requestValidator).loadService(ConfigService.class, (Object)configSvc).loadService(ResourceServiceClientService.class, (Object)rsrcSvcClientSvc).loadService(UserProfileDao.class, (Object)usrProfileDao).loadService(Authorizer.class, (Object)authorizer).loadService(RequestIdentityAsserter.class, (Object)idAsserter);
        ServiceLocator.load((ServiceLocator)locator);
    }

    private TCIniRealm getInitializedTCIniRealm(ServletContext sc) {
        TCIniRealm tcIniRealm = null;
        WebEnvironment env = (WebEnvironment)sc.getAttribute(ENVIRONMENT_ATTRIBUTE_KEY);
        Collection realms = ((RealmSecurityManager)env.getWebSecurityManager()).getRealms();
        for (Realm r : realms) {
            if (!(r instanceof TCIniRealm)) continue;
            tcIniRealm = (TCIniRealm)r;
            break;
        }
        if (tcIniRealm == null) {
            throw new RuntimeException("Failure instantiating TMS context. Failure to find expected security realm.");
        }
        return tcIniRealm;
    }

    boolean isSSLConfiguredWithKeyStoreAndTrustStore() {
        String property = System.getProperty("tms.ia.useSSL");
        if (property != null) {
            return "true".equals(property);
        }
        boolean keystoreIsThere = false;
        boolean trustStoreIsThere = false;
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(System.getProperty("jetty.home") + "/etc/jetty.xml");
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("/Configure/Call[contains(@name,'addConnector')]/Arg/New[contains(@class,'org.eclipse.jetty.server.ssl.SslSelectChannelConnector')]/Arg/New[contains(@class,'org.eclipse.jetty.http.ssl.SslContextFactory')]");
            Object sslContextFactoryNode = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)sslContextFactoryNode;
            Node sslContextFactoryNodeContent = nodes.item(0);
            if (sslContextFactoryNodeContent == null) {
                expr = xpath.compile("/Configure/Call[contains(@name,'addConnector')]/Arg/New[contains(@class,'org.eclipse.jetty.server.ssl.SslSelectChannelConnector')]/Arg/New[contains(@class,'org.eclipse.jetty.util.ssl.SslContextFactory')]");
                sslContextFactoryNode = expr.evaluate(doc, XPathConstants.NODESET);
                nodes = (NodeList)sslContextFactoryNode;
                sslContextFactoryNodeContent = nodes.item(0);
            }
            NodeList childNodes = sslContextFactoryNodeContent.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (Utils.trimToNull((String)childNode.getTextContent()) == null) continue;
                if (!keystoreIsThere) {
                    boolean bl = keystoreIsThere = childNode.getAttributes().item(0).getNodeValue().equals("keyStore");
                }
                if (trustStoreIsThere) continue;
                trustStoreIsThere = childNode.getAttributes().item(0).getNodeValue().equals("trustStore");
            }
        }
        catch (Exception e) {
            LOG.warn("Could not find out whether the Identity Assertion is using SSL or not, not using SSL then. " + e.getMessage());
        }
        return keystoreIsThere && trustStoreIsThere;
    }

    private void scheduleUpdateCheckIfNeeded() {
        if (!Boolean.getBoolean("com.terracotta.management.skipUpdateCheck")) {
            this.updateCheckTimer = new Timer(true);
            this.updateCheckTimer.scheduleAtFixedRate((TimerTask)new UpdateChecker(HAS_LICENSE.booleanValue()), 1000L, 604800000L);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(TMSEnvironmentLoaderListener.class);
    }
}

