/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.impl;

import com.terracotta.management.security.InvalidRequestTicketException;
import com.terracotta.management.security.RequestTicketMonitor;
import com.terracotta.management.security.impl.DfltRequestTicketMonitor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DfltRequestTicketMonitor
implements RequestTicketMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(DfltRequestTicketMonitor.class);
    private static final long TICKET_LIFETIME = TimeUnit.MINUTES.toMillis(1L);
    private final LinkedList<RequestTicket> issuedTickets = new LinkedList();

    public synchronized String issueRequestTicket() {
        this.cleanupOldsters();
        RequestTicket ticket = new RequestTicket(this, null);
        boolean added = this.issuedTickets.add(ticket);
        return added ? ticket.getTicketId().toString() : null;
    }

    public synchronized void redeemRequestTicket(String ticket) throws InvalidRequestTicketException {
        RequestTicket found = null;
        Iterator itr = this.issuedTickets.iterator();
        while (itr.hasNext()) {
            RequestTicket next = (RequestTicket)itr.next();
            if (!ticket.equals(next.getTicketId().toString())) continue;
            itr.remove();
            found = next;
            break;
        }
        if (found == null) {
            throw new InvalidRequestTicketException(String.format("Unknown ticket cannot be redeemed. Either ticket '%s' has expired prior to this redemption attempt or this is a replay attack!", ticket));
        }
    }

    private void cleanupOldsters() {
        boolean removed;
        do {
            RequestTicket oldest;
            if ((oldest = (RequestTicket)this.issuedTickets.peek()) != null && oldest.isExpired()) {
                removed = this.issuedTickets.remove(oldest);
                if (!removed) continue;
                LOG.debug("RequestTicket '{}' has expired and has been removed from the issuedTickets queue.", (Object)oldest);
                continue;
            }
            removed = false;
        } while (removed);
    }

    static /* synthetic */ long access$100() {
        return TICKET_LIFETIME;
    }
}

