/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    public static String VERSION_FULL = "UNKNOWN";
    public static String VERSION_MAJOR = "UNKNOWN";
    public static String VERSION_MINOR = "UNKNOWN";
    public static String VERSION_ITERATION = "UNKNOWN";
    public static String BUILD_TIMESTAMP = "UNKNOWN";
    public static String BUILD_REVISION = "UNKNOWN";
    public static String PRODUCT_NAME = "UNKNOWN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = BuildInfo.class.getClassLoader().getResourceAsStream("tmc-version.properties");
            if (is != null) {
                props.load(is);
                String version = props.getProperty("version");
                if (version != null) {
                    VERSION_FULL = version;
                    String[] versionComponents = version.split("\\.");
                    VERSION_MAJOR = versionComponents[0];
                    VERSION_MINOR = versionComponents[1];
                    VERSION_ITERATION = versionComponents.length > 2 ? versionComponents[2] : "0";
                } else {
                    LoggerFactory.getLogger(BuildInfo.class).error("Can't parse TMC version from tmc-version.properties");
                }
                BUILD_TIMESTAMP = props.getProperty("build-time", "UNKNOWN");
                BUILD_REVISION = props.getProperty("build-revision", "UNKNOWN");
                PRODUCT_NAME = props.getProperty("product-name", "UNKNOWN");
            } else {
                LoggerFactory.getLogger(BuildInfo.class).warn("Error loading version info from tmc-version.properties - resource was not found.");
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(BuildInfo.class).error("Error loading version info from tmc-version.properties.", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

