/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.services;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;

/**
 * An interface for jersey client factory implementations.
 *
 * @author brandony
 */
public interface JerseyClientFactory {
  /**
   * A key for the client base uri in the property bag.
   */
  public static final String CLIENT_BASE_URI = "CLIENT_BASE_URI";

  /**
   * A key for the identifier of client cert authorization in the property bag.
   */
  public static final String CLIENT_CERT_AUTH_ENABLED = "CLIENT_CERT_AUTH_ENABLED";

  /**
   * A key for the identifier of the clients security state in the property bag.
   */
  public static final String SECURITY_ENABLED = "SECURITY_ENABLED";

  /**
   * The factory method for creating new clients.
   *
   * @param clientConfig provides the configuration of the client to be created.
   * @return the jersey {@code Client}
   */
  Client createClient(ClientConfig clientConfig);
}
