/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security.web.jersey;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.terracotta.management.security.IACredentials;

/**
 * The {@code ClientFilter} associated with non licensed (non-secure) TMS clients.
 *
 * @author brandony
 */
public class TMSRequestClientFilter extends ClientFilter {
  @Override
  public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
    cr.getHeaders().remove(IACredentials.TC_ID_TOKEN);
    return getNext().handle(cr);
  }
}
