/**
 * stdio.js
 *
 * Overrides of standard Javascript dialogs (alert, confirm, and prompt) using Kendo Window.
 * 
 * These functions are different from the standards in that the don't block but rather use callbacks. The Kendo windows themselves do
 * block input to the rest of the browser page with a semi-opaque overlay.
 * 
 * author: gkeim
 * date: 7/20/12
 */
(function() {
  var TITLE = 'Terracotta Management Console',
    MIN_WIDTH = 260;
  
  window.alert = function(msg, callback) {
    var that = this,
      $alert = $('#alert');
    
    $alert.find('#msg').html(msg);
    $alert.on('click', 'button', function(e) {
      kPopup.close();
      $alert.hide();  
    });
    var kPopup = $alert.kendoWindow({
      title: TITLE,
      width: 'auto',
      minWidth: MIN_WIDTH,
      modal: true,
      close: function(e) {
        if (typeof(callback) == 'function') {
          callback.call(that);
        }
      }
    }).data('kendoWindow');
    $alert.show();
    kPopup.center();
    kPopup.open();
  };
        
  window.confirm = function(msg, callback) {
    var that = this,
      $confirm = $('#confirm');
    
    $confirm.removeData('value');
    $confirm.find('#msg').html(msg);
    $confirm.on('click', 'button', function(e) {
      var value = (e.srcElement.id == 'cancel') ? false : true;
      $confirm.data('value', value);
      kPopup.close();
      $confirm.hide();
    });
    var kPopup = $confirm.kendoWindow({
      title: TITLE,
      width: 'auto',
      minWidth: MIN_WIDTH,
      modal: true,
      close: function(e) {
        if (typeof(callback) == 'function') {
          callback.call(that, $confirm.data('value'));
        }
      }
    }).data('kendoWindow');
    $confirm.show();
    kPopup.center();
    kPopup.open();
  };

  window.prompt = function(prompt, callback, defaultValue) {
    var that = this,
      prompt = $('#prompt'),
      $field = $prompt.find('#input');
    
    $prompt.removeData('value');
    $prompt.find('#msg').html(prompt);
    if (defaultValue != null) {
      $field.val(defaultValue.toString());
    }
    $prompt.on('click', 'button', function(e) {
      var value = (e.srcElement.id == 'cancel') ? null : $field.val();
      $prompt.data('value', value);
      kPopup.close();
      $prompt.hide();
    });
    var kPopup = $prompt.kendoWindow({
      title: TITLE,
      width: 'auto',
      minWidth: MIN_WIDTH,
      modal: true,
      close: function(e) {
        if (typeof(callback) == 'function') {
          callback.call(that, $prompt.data('value'));
        }
      }
    }).data('kendoWindow');
    $prompt.show();
    kPopup.center();
    kPopup.open();
    return $prompt.data('value');
  };
})();
