function AgentManagementPage(agentPage, $content) {
  BaseAgentPage.call(this, agentPage, $content);

  var that = this;
  that.gridDS = new kendo.data.DataSource({
    data: [],
    schema: {
      model: {
        id: "name",
        fields: {
          name:         {type: "string", editable: true},
          enabled:      {type: "string", editable: true},
          statistics:   {type: "string", editable: true},
          elementCount: {type: "number", editable: true}
        }
      }
    },
    sort: {field: "name", dir: "asc"}
   });
  that.$grid = $content.find("#grid").kendoTGrid({
    dataSource: that.gridDS,
    columns: [
      {
        title: "CacheManager",
        field: "name",
        editor: function(container, options) {
          $("<button name='" + options.field + "' type='button' class='k-button edit-cacheManager-config-button'>Edit Config</button>")
            .appendTo(container);
        },
        width: "40%"
      },
      {
        title: "Enabled",
        field: "enabled",
        template: "#=enabled# / #=cacheCount#",
        editor: function(container, options) {
          var enabled = options.model.enabled,
            cacheCount = options.model.cacheCount;
          
          if (cacheCount > 0) {
            if (enabled < cacheCount) {
              $("<button name='" + options.field + "' type='button' class='k-button enable-caches-button'>Enable All</button>")
                .appendTo(container);
            }
            if (enabled > 0) {
              $("<button name='" + options.field + "' type='button' class='k-button'>Disable All</button>")
                .appendTo(container);
            }
          }
        },
        width: "20%"
      },
      {
        title: "Statistics",
        field: "statistics",
        template: "#=statistics# / #=cacheCount#",
        editor: function(container, options) {
          var statistics = options.model.statistics,
            cacheCount = options.model.cacheCount;
        
          if (cacheCount > 0) {
            if (statistics < cacheCount) {
              $("<button name='" + options.field + "' type='button' class='k-button enable-statistics-button'>Enable All</button>")
                .appendTo(container);
            }
            if (statistics > 0) {
              $("<button name='" + options.field + "' type='button' class='k-button'>Disable All</button>")
                .appendTo(container);
            }
          }
        },
        width: "20%"
      },
      {
        title: "Element Count",
        field: "elementCount",
        template: '#= formatIntRightJustified(elementCount) #',
        editor: function(container, options) {
          $("<button name='" + options.field + "' type='button' class='k-button'>Clear Caches</button>")
            .appendTo(container);
        },
        width: "20%"
      }
    ],
    selectable: "row",
    sortable: true,
    pageable: false,
    scrollable: true,
    resizable: true,
    reorderable: true,
    editable: "incell",
    detailInit: $.proxy(that.cacheDetailInit, that)
  });
  var kGrid = that.$grid.data("kendoTGrid");
  var clickDelegate = function(e) {
    var $this = $(this);
    
    $this.text("Wait...");
    e.preventDefault();
    e.stopPropagation();
    return kGrid.dataItem($this.closest("tr"));
  };
  var resultHandler = function(result, callback) {
    var store = $.extend({}, result);
    
    $.each(result, function(cacheName, jqXHR) {
      jqXHR.always(function () {
        delete store[cacheName];

        if ($.isEmptyObject(store)) {
          if (kGrid.editable) {
            kGrid.closeCell();
          }
          callback.call();
          return false;
        }
      });
    });
  };
  
  var editCacheManagerConfigHandler = function(e) {
    that.$grid.off("click", "button[name='name']", editCacheManagerConfigHandler);

    var dataItem = clickDelegate.call(this, e);
    if (dataItem) {
      that.editCacheManagerConfig(dataItem.name);
      if (kGrid.editable) {
        kGrid.closeCell();
      }
    }
    that.$grid.on("click", "button[name='name']", editCacheManagerConfigHandler);
  };
  that.$grid.on("click", "button[name='name']", editCacheManagerConfigHandler);

  var enableHandler = function(e) {
    that.$grid.off("click", "button[name='enabled']", enableHandler);

    var $this = $(this),
      dataItem = clickDelegate.call(this, e);
  
    if (dataItem) {
      var value = $(this).hasClass("enable-caches-button"),
        result = that.setCacheManagerEnabled(dataItem.name, value);
  
      resultHandler.call(this, result, function() {
        that.$grid.on("click", "button[name='enabled']", enableHandler);
      });
    }
  };
  that.$grid.on("click", "button[name='enabled']", enableHandler);
  
  var statisticsHandler = function(e) {
    that.$grid.off("click", "button[name='statistics']", statisticsHandler);

    var $this = $(this),
      dataItem = clickDelegate.call(this, e);

    if (dataItem) {
      var value = $(this).hasClass("enable-statistics-button"),
        result = that.setCacheManagerStatisticsEnabled(dataItem.name, value);
  
      resultHandler.call(this, result, function() {
        that.$grid.on("click", "button[name='statistics']", statisticsHandler);
      });
    }
  };
  that.$grid.on("click", "button[name='statistics']", statisticsHandler);
  
  var clearCacheHandler = function(e) {
    that.$grid.off("click", "button[name='elementCount']", clearCacheHandler);

    var $this = $(this),
      dataItem = clickDelegate.call(this, e);

    if (dataItem) {
      var result = that.clearCacheManagerContents(dataItem.name);
      
      resultHandler.call(this, result, function() {
        that.$grid.on("click", "button[name='elementCount']", clearCacheHandler);
      });
    }
  };
  that.$grid.on("click", "button[name='elementCount']", clearCacheHandler);

  this.expandedCacheManagers = {};

  this.CACHE_ATTRIBUTES = [
    "Enabled",
    "StatisticsEnabled",
    "Size",
    "TerracottaClustered"
  ];
  
  this.CACHE_MANAGER_ATTRIBUTES = [
    "CacheNames"
  ];
  
  this.CACHE_CONFIG_ATTRS = [
    "MaxElementsOnDisk",
    "MaxBytesLocalDisk",
    "MaxBytesLocalDiskAsString",
    "MaxBytesLocalHeap",
    "MaxBytesLocalHeapAsString",
    "LoggingEnabled",
    "TimeToIdleSeconds",
    "TimeToLiveSeconds",
    "MaxEntriesLocalHeap"
  ];
  
  this.CACHE_MANAGER_CONFIG_ATTRS = [
     "MaxBytesLocalDiskAsString",
     "MaxBytesLocalDisk",
     "MaxBytesLocalHeapAsString",
     "MaxBytesLocalHeap"
   ];
  
  resizeHandler($content, function(e) {
    assignRemainingHeight(that.$grid);
    that.$grid.data("kendoTGrid")._setContentHeight();
  });
}

AgentManagementPage.prototype = $.extend({}, BaseAgentPage.prototype, {
  toString: function() {
    return "AgentManagementPage";
  },

  keydownHandler: function(e) {
    switch (e.which) {
      case kendo.keys.ESC: {
        var $grid = $(e.target).closest(".k-grid");
        if ($grid != null) {
          var kGrid = $grid.data("kendoTGrid");
          if (kGrid.editable) {
            kGrid.closeCell();
          }
        }
        break;
      }
    }
  },
  
  show: function() {
    $(document).bind("keydown", this.keydownHandler);
    BaseAgentPage.prototype.show.call(this);
  },
  
  hide: function() {
    $(document).bind("keydown", this.keydownHandler);
    BaseAgentPage.prototype.hide.call(this);
  },
  
  getCacheAttributes: function() {
    return this.CACHE_ATTRIBUTES;
  },
  
  getCacheManagerAttributes: function() {
    return this.CACHE_MANAGER_ATTRIBUTES;
  },
  
  cacheDetailInit: function(e) {
    this.exposeCaches(e.data.name, e.detailCell);
  },

  handleCachesAdded: function(e) {},
  
  handleCacheAdded: function(e) {},
 
  handleCacheRemoved: function(e) {
    var cacheManagerName = e.cacheManagerName,
      cacheName = e.cacheName;
    
    if (this.expandedCacheManagers[cacheManagerName]) {
      this.removeExposedCache(cacheManagerName, cacheName);
    }
  },
  
  handleCacheManagerAdded: function(e) {},
  
  handleCacheManagerRemoved: function(e) {
    var cacheManagerName = e.cacheManagerName;
    
    if (this.expandedCacheManagers[cacheManagerName]) {
      delete this.expandedCacheManagers[cacheManagerName];
    }
    this.$grid.data("kendoTGrid").removeModel(cacheManagerName);
  },
  
  handleCacheDetails: function(e) {
    var cacheManagerName = e.cacheManagerName,
      cacheManagerAttrs = this.agentPage.cacheManagers[cacheManagerName],
      elementCount = 0,
      cacheEnabledCount = 0,
      cacheStatisticsCount = 0,
      cacheCount = cacheManagerAttrs.CacheNames.length;
    
    $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttrs) {
      if (cacheAttrs.Enabled) {
        cacheEnabledCount++;
      }
      if (cacheAttrs.StatisticsEnabled) {
        cacheStatisticsCount++;
      }
      elementCount += cacheAttrs.Size;
    });
    
    var kGrid = this.$grid.data("kendoTGrid");
    if (kGrid.editable == null) {
      kGrid.updateModel(cacheManagerName, {
        name: cacheManagerName,
        cacheCount: cacheCount,
        enabled: cacheEnabledCount,
        statistics: cacheStatisticsCount,
        elementCount: elementCount
      });
    }

    if (this.expandedCacheManagers[cacheManagerName]) {
      this.updateExposedCaches(cacheManagerName);
    }
  },

  handleResponseComplete: function(e) {
    var kGrid = this.$grid.data("kendoTGrid");
    
    if (kGrid.editable == null && $.isEmptyObject(this.expandedCacheManagers)) {
      this.gridDS.fetch();
    }
  },
  
  refresh: function() {},
  
  updateExposedCaches: function(cacheManagerName) {
    var that = this;
    var cacheManagerAttrs = this.agentPage.cacheManagers[cacheManagerName];
    var $grid = this.expandedCacheManagers[cacheManagerName];
    var kGrid = $grid.data("kendoTGrid");
    
    if ($grid && kGrid.editable == null) {
      $.each(cacheManagerAttrs.caches, function(cacheName, cacheAttrs) {
        var entry = {
          cacheName: cacheName,
          enabled: cacheAttrs.Enabled,
          statistics: cacheAttrs.StatisticsEnabled,
          elementCount: cacheAttrs.Size,
          terracottaClustered: cacheAttrs.TerracottaClustered
        };
        kGrid.updateModel(cacheName, entry);        
      });
      kGrid.dataSource.fetch();
    }
  },

  exposeCaches: function(cacheManagerName, target) {
    var that = this;
    var cacheManagerAttrs = this.agentPage.cacheManagers[cacheManagerName];
    var caches = cacheManagerAttrs.caches;
    var cacheData = [];
    
    if (caches != null) {
      $.each(caches, function(cacheName, cacheAttrs) {
        cacheData.push({
          cacheName:           cacheName,
          terracottaClustered: cacheAttrs.TerracottaClustered,
          enabled:             cacheAttrs.Enabled,
          statistics:          cacheAttrs.StatisticsEnabled,
          elementCount:        cacheAttrs.Size
        });
      });
    }
    
    var ds = new kendo.data.DataSource({
      data: cacheData,
      schema: {
        model: {
          id: "cacheName",
          fields: {
            cacheName:           {type: "string", editable: true},
            terracottaClustered: {type: "boolean", editable: false},
            enabled:             {type: "boolean", editable: true},
            statistics:          {type: "boolean", editable: true},
            elementCount:        {type: "number", editable: true}
          }
        }
      },
      sort: {field: "cacheName", dir: "asc"},
      pageSize: 5
    });
    
    if(cacheData.length > 0) {
      $grid = $("<div/>").appendTo(target).kendoTGrid({
        dataSource: ds,
        scrollable: true,
        resizable: true,
        selectable: "row",
        sortable: true,
        pageable: true,
        editable: "incell",
        columns: [
          {
            title: "Cache",
            field: "cacheName",
            template: "# if (terracottaClustered) { # <div title='Terracotta-clustered' class='clusteredCache'> # } else { # <div class='nonClusteredCache'> # } # #= cacheName # </div>",
            editor: function(container, options) {
              $("<button name='" + options.field + "' type='button' class='k-button edit-cache-config-button'>Edit Config</button>")
                .appendTo(container);
            },
            width: "40%"
          },
          {
            title: "Enabled",
            field: "enabled",
            editor: function(container, options) {
              var msg = options.model.enabled ? "Disable" : "Enable";
              $("<button name='" + options.field + "' type='button' class='k-button'>" + msg + "</button>")
                .appendTo(container);
            },
            width: "20%"
          },
          {
            title: "Statistics",
            field: "statistics",
            editor: function(container, options) {
              var msg = options.model.statistics ? "Disable" : "Enable";
              $("<button name='" + options.field + "' type='button' class='k-button'>" + msg + "</button>")
                .appendTo(container);
            },
            width: "20%"
          },
          {
            title: "Element Count",
            field: "elementCount",
            template: '#= formatIntRightJustified(elementCount) #',
            editor: function(container, options) {
              $("<button name='" + options.field + "' type='button' class='k-button'>Clear cache</button>")
                .appendTo(container);
            },
            width: "20%"
          }
        ]
      });
      var kGrid = $grid.data("kendoTGrid");
      var clickDelegate = function(e) {
        var $this = $(this);
        
        $this.text("Wait...");
        e.preventDefault();
        e.stopPropagation();
        return kGrid.dataItem($this.closest("tr"));
      };
      
      var editCacheConfigHandler = function(e) {
        that.$grid.off("click", "button[name='cacheName']", editCacheConfigHandler);

        var dataItem = clickDelegate.call(this, e);
        if (dataItem) {
          that.editCacheConfig(cacheManagerName, dataItem.cacheName);
          if (kGrid.editable) {
            kGrid.closeCell();
          }
        }
        that.$grid.on("click", "button[name='cacheName']", editCacheConfigHandler);
      };
      that.$grid.on("click", "button[name='cacheName']", editCacheConfigHandler);

      var enableHandler = function(e) {
        $grid.off("click", "button[name='enabled']", enableHandler);

        var dataItem = clickDelegate.call(this, e);
        if (dataItem) {
          var result = that.setCacheEnabled(cacheManagerName, dataItem.cacheName, !dataItem.enabled);
          result.always(function() {
            if (kGrid.editable) {
              kGrid.closeCell();
            }
            $grid.on("click", "button[name='enabled']", enableHandler);
          });
        }
      };
      $grid.on("click", "button[name='enabled']", enableHandler);
      
      var statisticsHandler = function(e) {
        $grid.off("click", "button[name='statistics']", statisticsHandler);

        var dataItem = clickDelegate.call(this, e);
        if (dataItem) {
          var result = that.setCacheStatisticsEnabled(cacheManagerName, dataItem.cacheName, !dataItem.statistics);
          result.always(function() {
            if (kGrid.editable) {
              kGrid.closeCell();
            }
            $grid.on("click", "button[name='statistics']", statisticsHandler);
          });
        }
      };
      $grid.on("click", "button[name='statistics']", statisticsHandler);
      
      var clearCacheHandler = function(e) {
        $grid.off("click", "button[name='elementCount']", clearCacheHandler);

        var dataItem = clickDelegate.call(this, e);
        if (dataItem) {
          var result = that.clearCacheContents(cacheManagerName, dataItem.cacheName);
          result.always(function() {
            if (kGrid.editable) {
              kGrid.closeCell();
            }
            $grid.on("click", "button[name='elementCount']", clearCacheHandler);
          });
        }
      };
      $grid.on("click", "button[name='elementCount']", clearCacheHandler);
      this.expandedCacheManagers[cacheManagerName] = $grid;
    }
    else {
      $grid = $("<span>").appendTo(target).html("&nbsp;&nbsp; - - This CacheManager has no Caches.");
    }
  },
  
  removeExposedCache: function(cacheManagerName, cacheName) {
    var that = this,
      $detailGrid = this.expandedCacheManagers[cacheManagerName];
    
    if ($detailGrid) {
      $detailGrid.data("kendoTGrid").removeModel(cacheName);
    }
  },
  
  editCacheManagerConfig: function(name) {
    $.xhrPool.suspend();
    
    this.requestCacheManagerConfig(name).done(function(data) {
      if (data.length > 0) {
        var cacheManagerAttrs = data[0].attributes;
        cacheManagerAttrs.Name = name;
        this.getCacheManagerConfigEditor().show(cacheManagerAttrs);
      }
    }).fail(function(jqXHR, textStatus, errorThrown) {
      alert("Failed to get CacheManager configuration: " + textStatus);
    }).always(function() {
      $.xhrPool.resume();
    });
  },

  getCacheManagerConfigEditor: function() {
    if (this.$cacheManagerConfigEditor == null) {
      this.$cacheManagerConfigEditor = new CacheManagerConfigEditor(this);
    }
    return this.$cacheManagerConfigEditor;
  },
  
  getCacheConfigEditor: function() {
    if (this.$cacheConfigEditor == null) {
      this.$cacheConfigEditor = new CacheConfigEditor(this);
    }
    return this.$cacheConfigEditor;
  },
  
  buildCacheConfigRequest: function(cacheManagerName, cacheName) {
    return "api/agents;ids=" + this.agentPage.getId() + "/cacheManagers;names="
      + cacheManagerName + "/caches;names=" + cacheName + "?show=" + this.CACHE_CONFIG_ATTRS.join("&show=");
  },
  
  requestCacheConfig: function(cacheManagerName, cacheName) {
    var jqxhr = $.ajax({
      type: "GET",
      url: encodeURI(this.buildCacheConfigRequest(cacheManagerName, cacheName)),
      context: this,
      dataType: "json"
    });
    return jqxhr;
  },

  buildCacheManagerConfigRequest: function(cacheManagerName) {
    return "api/agents;ids=" + this.agentPage.getId() + "/cacheManagers;names="
      + cacheManagerName + "?show=" + this.CACHE_MANAGER_CONFIG_ATTRS.join("&show=");
  },
  
  requestCacheManagerConfig: function(cacheManagerName) {
    var jqxhr = $.ajax({
      type: "GET",
      url: encodeURI(this.buildCacheManagerConfigRequest(cacheManagerName)),
      context: this,
      dataType: "json"
    });
    return jqxhr;
  },
  
  editCacheConfig: function(cacheManagerName, cacheName) {
    $.xhrPool.suspend();
    
    this.requestCacheManagerConfig(cacheManagerName).done(function(data) {
      if (data.length > 0) {
        var cacheManagerAttrs = data[0].attributes;
        
        cacheManagerAttrs.Name = data[0].name;
        this.requestCacheConfig(cacheManagerName, cacheName).done(function(data) {
          if (data.length > 0) {
            var cacheAttrs = data[0].attributes;
            cacheAttrs.CacheName = data[0].name;
            this.getCacheConfigEditor().show(cacheManagerAttrs, cacheAttrs);
          }
        }).fail(function(jqXHR, textStatus, errorThrown) {
          alert("Failed to get Cache configuration: " + textStatus);
        }).always(function() {
          $.xhrPool.resume();
        });
      }
    }).fail(function(jqXHR, textStatus, errorThrown) {
      alert("Failed to get CacheManager configuration: " + textStatus);
      $.xhrPool.resume();
    });
  },
  
  setCacheEnabled: function(cacheManagerName, cacheName, enabled) {
    return this.updateCache(cacheManagerName, cacheName, {Enabled: enabled});
  },
  
  setCacheStatisticsEnabled: function(cacheManagerName, cacheName, statisticsEnabled) {
    return this.updateCache(cacheManagerName, cacheName, {StatisticsEnabled: statisticsEnabled});
  },
  
  clearCacheContents: function(cacheManagerName, cacheName) {
    return this.clearCache(cacheManagerName, cacheName);
  },
  
  setCacheManagerEnabled: function(cacheManagerName, enabled) {
    var that = this,
      cacheManagerAttrs = that.agentPage.cacheManagers[cacheManagerName],
      result = {};

    if (cacheManagerAttrs) {
      $.each(cacheManagerAttrs.CacheNames, function(index, cacheName) {
        result[cacheName] = that.updateCache(cacheManagerName, cacheName, {Enabled: enabled});
      });
    }
    
    return result;
  },
  
  setCacheManagerStatisticsEnabled: function(cacheManagerName, statisticsEnabled) {
    var that = this,
      cacheManagerAttrs = that.agentPage.cacheManagers[cacheManagerName],
      result = {};

    if (cacheManagerAttrs) {
      $.each(cacheManagerAttrs.CacheNames, function(index, cacheName) {
        result[cacheName] = that.updateCache(cacheManagerName, cacheName, {StatisticsEnabled: statisticsEnabled})
      });
    }
    
    return result;
  },
  
  clearCacheManagerContents: function(cacheManagerName) {
    var that = this,
      cacheManagerAttrs = that.agentPage.cacheManagers[cacheManagerName],
      result = {};

    if (cacheManagerAttrs) {
      $.each(cacheManagerAttrs.CacheNames, function(index, cacheName) {
        result[cacheName] = that.clearCache(cacheManagerName, cacheName);
      });
    }
    
    return result;
  },
  
  updateCache: function(cacheManagerName, cacheName, attributes) {
    var agentId = this.agentPage.getId(),
      data = {
        cacheManagerName: cacheManagerName,
        name: cacheName,
        agentId: agentId,
        attributes: attributes
      },
      jsonData = JSON.stringify(data, null, 2);
    
    var jqxhr = $.ajax({
      type: "PUT",
      url: encodeURI("api/agents;ids=" + agentId + "/cacheManagers;names=" + cacheManagerName
        + "/caches;names=" + cacheName),
      processData: false,
      data: jsonData,
      contentType: "application/json",
      cancelable: false
    });
    return jqxhr;
  },
  
  clearCache: function(cacheManagerName, cacheName) {
    var jqxhr = $.ajax({
      type: "DELETE",
      url: encodeURI("api/agents;ids=" + this.agentPage.getId() + "/cacheManagers;names=" + cacheManagerName
        + "/caches;names=" + cacheName + "/elements"),
      cancelable: false
    });
    return jqxhr;
  },
  
  updateCacheManager: function(cacheManagerName, attributes) {
    var agentId = this.agentPage.getId(),
      jsonData = JSON.stringify({attributes: attributes}, null, 2);
    
    var jqxhr = $.ajax({
      type: "PUT",
      url: encodeURI("api/agents;ids=" + agentId + "/cacheManagers;names=" + cacheManagerName),
      processData: false,
      data: jsonData,
      contentType: "application/json",
      cancelable: false
    });
    return jqxhr;
  },
});