/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.config.resource.services;

import com.terracotta.management.config.Agent;
import com.terracotta.management.services.ConfigService;
import com.terracotta.management.services.impl.AgentNotAvailableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.management.ServiceExecutionException;
import org.terracotta.management.ServiceLocator;
import org.terracotta.management.resource.services.Utils;

@Path(value="/config")
public final class ConfigResourceService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigResourceService.class);
    @Context
    private UriInfo info;
    private final ConfigService configSvc = (ConfigService)ServiceLocator.locate(ConfigService.class);

    @POST
    @Deprecated
    public void save() {
        try {
            this.configSvc.saveConfig();
        }
        catch (ServiceExecutionException e) {
            LOG.error(e.getMessage(), e.getCause());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build());
        }
    }

    @GET
    @Path(value="/groups/{groupId}")
    @Produces(value={"application/json"})
    public Collection<Agent> getAgents(@PathParam(value="groupId") String groupId) {
        return this.configSvc.getAgentsByGroup(groupId);
    }

    @GET
    @Path(value="/groups")
    @Produces(value={"application/json"})
    public Collection<String> getGroups() {
        return this.configSvc.getGroups();
    }

    @PUT
    @Path(value="/groups/{groupId}")
    @Produces(value={"application/json"})
    public Response addGroup(@PathParam(value="groupId") String groupId) {
        boolean added = this.configSvc.addGroup(groupId);
        if (added) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Group created.").build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Group already exists.").build();
    }

    @PUT
    @Path(value="/groups/{oldGroupId}/{newGroupId}")
    @Produces(value={"application/json"})
    public Response addGroup(@PathParam(value="oldGroupId") String oldGroupId, @PathParam(value="newGroupId") String newGroupId) {
        boolean renamed = this.configSvc.renameGroup(oldGroupId, newGroupId);
        if (renamed) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Group renamed.").build();
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Group source group does not exist or destination group already exists.").build();
    }

    @DELETE
    @Path(value="/groups/{groupId}")
    @Produces(value={"application/json"})
    public Response deleteGroup(@PathParam(value="groupId") String groupId) {
        boolean deleted = this.configSvc.deleteGroup(groupId);
        if (deleted) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Group deleted.").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Group does not exist or is not empty.").build();
    }

    @GET
    @Path(value="/agents")
    @Produces(value={"application/json"})
    public Collection<Agent> getAgents() {
        ArrayList<Agent> agents = new ArrayList<Agent>();
        Collection groups = this.configSvc.getGroups();
        for (String groupId : groups) {
            Collection agentsByGroup = this.configSvc.getAgentsByGroup(groupId);
            agents.addAll(agentsByGroup);
        }
        return agents;
    }

    @POST
    @Path(value="/agents")
    @Consumes(value={"application/json"})
    public Response addAgent(Agent agent) {
        Response.ResponseBuilder responseBuilder;
        try {
            new URL(agent.getAgentLocation());
        }
        catch (MalformedURLException e) {
            Response.ResponseBuilder responseBuilder2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Invalid connection URL, %s", e.getMessage()));
        }
        if (Utils.trimToNull((String)agent.getName()) == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing name.");
        } else if (Utils.trimToNull((String)agent.getGroupId()) == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing groupId.");
        } else if (agent.getAgentLocation() == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing agentLocation.");
        } else if (!this.isValidURL(agent.getAgentLocation())) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Invalid agentLocation.");
        } else {
            try {
                if (this.configSvc.addAgent(agent)) {
                    this.configSvc.saveConfig();
                    UriBuilder builder = this.info.getRequestUriBuilder();
                    builder.segment(new String[]{agent.getId()});
                    responseBuilder = Response.status((Response.Status)Response.Status.CREATED).header("LOCATION", (Object)builder.build(new Object[0]));
                } else {
                    responseBuilder = Response.status((Response.Status)Response.Status.CONFLICT);
                }
            }
            catch (AgentNotAvailableException e) {
                responseBuilder = Response.status((Response.Status)Response.Status.GONE);
            }
            catch (ServiceExecutionException e) {
                responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("The configuration could not be persisted to the configuration file : " + e.getMessage()));
            }
        }
        return responseBuilder.build();
    }

    @GET
    @Path(value="/agents/{agentId}")
    @Produces(value={"application/json"})
    public Agent getAgent(@PathParam(value="agentId") String agentId) {
        return this.configSvc.getAgent(agentId);
    }

    @DELETE
    @Path(value="/agents/{agentId}")
    public Response deleteAgent(@PathParam(value="agentId") String agentId) {
        Response.ResponseBuilder responseBuilder = null;
        this.configSvc.deleteAgent(agentId);
        try {
            this.configSvc.saveConfig();
        }
        catch (ServiceExecutionException e) {
            responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("The configuration could not be persisted to the configuration file : " + e.getMessage()));
        }
        return responseBuilder != null ? responseBuilder.build() : null;
    }

    @PUT
    @Path(value="/agents/{agentId}")
    @Consumes(value={"application/json"})
    public Response updateAgent(@PathParam(value="agentId") String agentId, Agent agent) {
        Response.ResponseBuilder responseBuilder;
        if (Utils.trimToNull((String)agent.getName()) == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing name.");
        } else if (Utils.trimToNull((String)agent.getGroupId()) == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing groupId.");
        } else if (agent.getAgentLocation() == null) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Missing agentLocation.");
        } else if (!this.isValidURL(agent.getAgentLocation())) {
            responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid agent representation: Invalid agentLocation.");
        } else {
            try {
                if (this.configSvc.updateAgent(agentId, agent)) {
                    this.configSvc.saveConfig();
                    responseBuilder = Response.ok();
                } else {
                    responseBuilder = Response.status((Response.Status)Response.Status.NOT_MODIFIED);
                }
            }
            catch (AgentNotAvailableException e) {
                responseBuilder = Response.status((Response.Status)Response.Status.GONE);
            }
            catch (ServiceExecutionException e) {
                responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("The configuration could not be persisted to the configuration file : " + e.getMessage()));
            }
        }
        return responseBuilder.build();
    }

    @PUT
    @Path(value="/authentication")
    @Consumes(value={"application/json"})
    public Response authenticationEnabled(boolean authenticationEnabled) {
        Response.ResponseBuilder responseBuilder;
        try {
            this.configSvc.setAuthenticationEnabledAndRedeployTMSIfNeeded(Boolean.valueOf(authenticationEnabled));
            this.configSvc.saveConfig();
            responseBuilder = Response.ok();
        }
        catch (ServiceExecutionException e) {
            responseBuilder = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("The configuration could not be persisted to the configuration file : " + e.getMessage()));
        }
        return responseBuilder.build();
    }

    @GET
    @Path(value="/authentication")
    @Consumes(value={"application/json"})
    public Boolean authenticationEnabled() {
        return this.configSvc.isAuthenticationEnabled();
    }

    private boolean isValidURL(String agentLocation) {
        boolean valid = true;
        try {
            new URL(agentLocation);
        }
        catch (MalformedURLException e) {
            valid = false;
        }
        return valid;
    }
}

