/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.services;

import com.terracotta.management.config.Agent;
import org.terracotta.management.ServiceExecutionException;

import java.util.Collection;
import java.util.Observer;

/**
 * <p>A service interface for managing agent configuration.</p>
 *
 * @author brandony
 */
public interface ConfigService {
  Collection<Agent> getAgentsByGroup(String groupId);

  Collection<String> getGroups();

  boolean addGroup(String groupId);

  boolean deleteGroup(String groupId);

  boolean renameGroup(String oldGroupId, String newGroupId);

  Agent getAgent(String agentId);

  Collection<Agent> getAgents();

  void deleteAgent(String agentId);
  
  boolean addAgent(Agent agent);

  boolean updateAgent(String agentId, Agent agent);

  boolean saveConfig() throws ServiceExecutionException;
  
  void registerObserver(Observer observer);

  void setAuthenticationEnabledAndRedeployTMSIfNeeded(Boolean authenticationEnabled) throws ServiceExecutionException;
  
  Boolean isAuthenticationEnabled();
}
